/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef LOADERMD2_H
#define LOADERMD2_H

#include "animatedmesh.h"
#include "loader.h"
#include "include.h"

class CMd2Loader : public ILoader<CMesh>
{
public :

    // Constructeur
    CMd2Loader();

    // Destructeur
    ~CMd2Loader();

    // Charge un mesh
    CMesh* Load(const std::string &filename);

private:

	static float mAnorms[162][3];
	
	// en-tte MD2
	struct md2_header_t
	{
		sint32_t ident;          // nombre magique "IDP2"
		sint32_t version;        // version (doit tre 8)
			
		sint32_t skinwidth;      // largeur de texture
		sint32_t skinheight;     // hauteur de texture
			
		sint32_t framesize;      // taille d'une frame
			
		sint32_t nu_skins;      // nombre de skins
		sint32_t nu_vert;		// nombre de vertices par frame
		sint32_t nu_tex;        // nombre de coordonnes de texture
		sint32_t nu_faces;      // nombre de triangles
		sint32_t nu_glcmds;     // nombre de commandes openGL
		sint32_t nu_frames;     // nombre de frames
			
		sint32_t offset_skins;   // offset des skins
		sint32_t offset_tex;     // offset des coordonnes de texture
		sint32_t offset_faces;   // offset des triangles
		sint32_t offset_frames;  // offset des frames
		sint32_t offset_glcmds;  // offset des commandes openGL
		sint32_t offset_end;     // offset de la fin du fichier
			
	};
};

#endif	// LOADERMD2_H
