/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "music.h"

#define SND_BUFFERSIZE 32768	// 32 Ko

CMusic::CMusic(void)
{
	alGenBuffers(2,mBuffers);
}

CMusic::~CMusic(void)
{
	alDeleteBuffers(2,mBuffers);
}

void CMusic::Play(ALuint source,bool loop)
{
	// TODO: loop

	ALenum state;
	alGetSourcei(source,AL_SOURCE_STATE,&state);

	if(state!=AL_PLAYING)
	{
		Stream(mBuffers[0]);
		Stream(mBuffers[1]);
		alSourceQueueBuffers(source,2,mBuffers);
		CheckError();
		alSourcePlay(source);
		CheckError();
	}
}

bool CMusic::Update(ALuint source)
{
	int processed;
	alGetSourcei(source,AL_BUFFERS_PROCESSED,&processed);
	CheckError();
	
	bool wasplaying=(processed>0);
	while(processed--)
	{
		ALuint buffer;	
		alSourceUnqueueBuffers(source,1,&buffer);
		CheckError();
		if(Stream(buffer)) 
		{
			alSourceQueueBuffers(source,1,&buffer);
        	CheckError();
		}
	}
	
	if(wasplaying) alSourcePlay(source);
	return true;
}
 
bool CMusic::Stream(ALuint buffer)
{
	char data[SND_BUFFERSIZE];
	int size=Fill(data,SND_BUFFERSIZE);
	alBufferData(buffer,mFormat,data,size,mRate);
	CheckError();
	return true;
}

void CMusic::Empty(ALuint source)
{
	int queued;
	alGetSourcei(source,AL_BUFFERS_QUEUED,&queued);

	while(queued--)
	{
		ALuint buffer;
		alSourceUnqueueBuffers(source,1,&buffer);
		CheckError();
	}
}
