/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef MUSIC_H
#define MUSIC_H

#include "sample.h"
#include "include.h"

class CMusic : public CSample
{
public:
	CMusic(void);
	virtual ~CMusic(void);

	void Play(ALuint source,bool mLoop);
	bool Update(ALuint source);
 
protected:
	virtual int Fill(char *buffer,int size)=0;
	ALenum mFormat;
	ALsizei mRate;

private:
	bool Stream(ALuint buffer);
	void Empty(ALuint source);
	
	ALuint mBuffers[2];
};

typedef CSmartPtr<CMusic> pMusic;

#endif
