/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "object.h"
#include "mediamanager.h"
#include "octree.h"
#include "terrain.h"

CObject::CObject(pMesh mesh)
{
	mCastShadow=false;
	setMesh(mesh);
}


CObject::~CObject(void)
{

}

void CObject::setMesh(pMesh mesh)
{
	mMesh=mesh;
	if(mesh!=NULL)
	{
		setRadius(mesh->getRadius());
		if(mCastShadow) mesh->EnableShadowVolume();
	}
	else setRadius(-1.f);
	//if(mesh!=NULL) mAnimEnd=mMesh->getFrameNumber()-1;
}

pMesh CObject::getMesh(void) const
{
	return mMesh;
}

void CObject::setMaterial(pMaterial material)
{
	mForceMaterial = material;
}

void CObject::CastShadow(bool enable)
{
	mCastShadow=enable;
	if(mMesh!=NULL) 
	{
		if(enable) mMesh->EnableShadowVolume();
		else mMesh->DisableShadowVolume();
	}
}

float CObject::Intersect(const CCoord3 &pos,const CVector3 &move,float radius,CCoord3 *intersection)
{
	if(mMesh == NULL) return std::numeric_limits<float>::infinity();
	else return mMesh->Intersect(mCurrentFrame,pos,move,radius,intersection);
}

void CObject::Parameter(const std::string &param,const std::string &data)
{
	if(param == "file" || param == "mesh")	setMesh(MediaManager->Get<CMesh>(data));
	// TODO URGENT: Trs trs moche
	else if(param == "octree")				setMesh(new COctree(MediaManager->Get<CMesh>(data)));
	else if(param == "terrain")				setMesh(MediaManager->Get<CTerrain>(data));
	else if(param == "shadow")				CastShadow(data=="true");
	else if(param == "material") 			setMaterial(MediaManager->Get<CMaterial>(data));
	else CEntity::Parameter(param,data);
}

int CObject::Draw(int pass)
{
	if(mMesh==NULL) return 0;

	if(pass == 0)
	{
		if(mCastShadow) CScene::Current->RegisterShadowCaster(this);
		return 0;
	}
	return mMesh->Draw(pass,mCurrentFrame,mForceMaterial);
}

int CObject::DrawShadowVolume(const CVector3 &light,bool directional)
{
	// TODO URGENT: clipping
	
	int count=0;
	if(mMesh!=NULL)
	{
		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		
		CMatrix4 matrix(getGlobalMatrix());
		matrix.Apply();
		if(directional) matrix(0,3)=matrix(1,3)=matrix(2,3)=0.f;	// enlve la translation

		count=mMesh->DrawShadowVolume(mCurrentFrame,light*matrix.Inverse(),directional);
		
		glPopMatrix();
	} 
	return count;
}
