/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef OBJECT_H
#define OBJECT_H

#include "smartptr.h"

class CObject;
typedef CSmartPtr<CObject> pObject;

#include "entity.h"
#include "mesh.h"
#include "include.h"

// Classe CObject: Instance d'un CMesh
class CObject : public CEntity
{
public:
	CObject(pMesh mesh=NULL);
	virtual ~CObject(void);

	void setMesh(pMesh mesh);
	pMesh getMesh(void) const;
	void setMaterial(pMaterial material);
	
	void CastShadow(bool enable);

	virtual float Intersect(const CCoord3 &pos,const CVector3 &move,float radius,CCoord3 *intersection);
	
	virtual void Parameter(const std::string &param,const std::string &data);
	virtual int Draw(int pass);

	virtual int DrawShadowVolume(const CVector3 &light,bool directional);

private:
	pMesh		mMesh;
	pMaterial	mForceMaterial;
	bool		mCastShadow;

};

#endif
