/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef OCTREE_H
#define OCTREE_H

#include "mesh.h"
#include "buffer.h"
#include "frustum.h"
#include "include.h"

#define OCTREE_MAXFACES 256

class COctree : public CMesh
{
public:
	COctree(const float *vertices, 
			index_t nvertices,
			index_t *indices, 
			index_t nindices,
			const float **texcoords,
			int ntexcoords);

	COctree(pMesh mesh=NULL);
	~COctree(void);

	void Build(void);
	
	void Update(void);
	float Intersect(double frame,const CCoord3 &pos,const CVector3 &move,float radius,CCoord3 *intersection);
	int Draw(int pass,double frame,pMaterial force);

private:
	class CNode;
	typedef CSmartPtr<CNode> pNode;

	class CNode : public IRefCount
	{
	public:
		CNode(void);
		~CNode(void);

		typedef CSmartPtr<IndexBuffer_t> pIndexBuffer;
		
		void Build(index_t pos,index_t nbr,index_t *indices,const float *vertices,pMaterial material);
		void Update(const index_t *indices,const float *vertices);
		float Intersect(const CCoord3 &pos,const CVector3 &move,float radius,CCoord3 *intersection,const index_t *indices,const float *vertices);
		int Draw(pFrustum frustum, pIndexBuffer indexbuffer,pMaterial force);

	private:
		int getSubNode(const CCoord3 &pos);
		void FitBox(const CCoord3 &pos);
		
		CCoord3			mMin,mMax;				// dlimitations de la boite		
		pNode			mChilds[8];				// enfants

		typedef std::pair<index_t,index_t>		Segment_t;
		typedef std::map<pMaterial,Segment_t>	SegmentsMap_t;
		SegmentsMap_t	mSegments;
	};

	pNode	mRootNode;
};

typedef CSmartPtr<COctree> pOctree;

#endif
