/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "oggvorbisloader.h"
#include "vorbisstream.h"	// inclue headers ogg vorbis

#define OGG_BUFFERSIZE 2048

CSample* COggVorbisSampleLoader::Load(const std::string& filename)
{
	FILE *file=fopen(filename.c_str(),"rb");
	if(!file) throw CLoadingFailed(filename, "Le fichier n'existe pas");

	OggVorbis_File vorbisFile;
	if(ov_open(file,&vorbisFile,NULL,0)<0)
	{
		fclose(file);
		throw CLoadingFailed(filename, "Format du fichier incorrect");
	}
	
	vorbis_info *vorbisInfo=ov_info(&vorbisFile, -1);

	ALenum format;
	if(vorbisInfo->channels==1) format = AL_FORMAT_MONO16;
    	else format = AL_FORMAT_STEREO16;

	std::vector<char> data;
	long result;
	for(;;)
	{
		int section;
		char buffer[OGG_BUFFERSIZE];
		result=ov_read(&vorbisFile,buffer,OGG_BUFFERSIZE,0,2,1,&section);
		if(result>0) data.insert(data.end(),buffer,buffer+result);
		else break;	// TODO: errors ?
	}

	CSample *sample = new CSample(	reinterpret_cast<void*>(&data[0]),
									format,
									data.size(),
									vorbisInfo->rate);

	ov_clear(&vorbisFile);

	return sample;
}

CMusic* COggVorbisMusicLoader::Load(const std::string& filename)
{
	return new CVorbisStream(filename);
}
