/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef PARTICLE_H
#define PARTICLE_H

#include "material.h"
#include "vector3.h"
#include "include.h"

class CEmitter;
typedef CSmartPtr<CEmitter> pEmitter;

// classe reprsentant une particule
class CParticle : public IRefCount
{
public:
	CParticle(pEmitter emitter);
	~CParticle(void);

protected:
	CCoord3		mPos;			// Position
	pMaterial	mMaterial;		// Matriau
	float		mSizex,mSizey;	// Taille
	float		mAnglez;		// Angle en Z
	float		mLife;			// Vie
	float		mStartLife;		// Vie au dpart
	CVector3	mSpeed;			// Vitesse
	pEmitter	mEmitter;		// Emetteur

	friend class CEmitter;
	friend class CScene;
};

typedef CSmartPtr<CParticle> pParticle;

#include "emitter.h"

#endif
