/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "plain.h"
#include "mediamanager.h"

CPlain::CPlain(float x,float y,pMaterial material)
{
	setMaterial(material);
	setSize(x,y);

}

CPlain::~CPlain(void)
{

}

void CPlain::setSize(float x,float y)
{
	mSizex=fabs(x)/2.f;
	mSizey=fabs(y)/2.f;
	setRadius(std::sqrt(mSizex*mSizex+mSizey*mSizey));
}

void CPlain::Parameter(const std::string &param,const std::string &data)
{
	std::stringstream sdata(data);
	
	if(param == "material")			setMaterial(MediaManager->Get<CMaterial>(data));
	else if(param == "size")		
	{
		float x,y;
		sdata>>x;
		sdata>>y;
		setSize(x,y);
	}
	else CEntity::Parameter(param,data);
}

int CPlain::Draw( int pass)
{
	if(pass==0) return 0;
	if(mMaterial==NULL) mMaterial=CMaterial::Default;
	if(mMaterial->Bind(pass,1.f,false))
	{
		glBegin(GL_QUADS);
		glNormal3f(0.0f,0.0f,-1.0f);
		glTexCoord2f(0.0f,0.0f);
		glVertex2f(-mSizex,-mSizey);
		glTexCoord2f(1.0f,0.0f);
		glVertex2f(mSizex,-mSizey);
		glTexCoord2f(1.0f,1.0f);
		glVertex2f(mSizex,mSizey);
		glTexCoord2f(0.0f,1.0f);
		glVertex2f(-mSizex,mSizey);
		glEnd();
		mMaterial->Unbind();
		return 2;
	}
	else return 0;
}
