/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "entity.h"
#include "material.h"
#include "include.h"

#ifndef PLAIN_H
#define PLAIN_H

class CPlain : public CEntity
{
public:
	CPlain(float sizex=1.f,float sizey=1.f,pMaterial material=NULL);
	~CPlain(void);

	inline void setMaterial(pMaterial mat)			{mMaterial = mat;}
	inline pMaterial getMaterial(void)				{return mMaterial;}
	void setSize(float x,float y);
	
	void Parameter(const std::string &param,const std::string &data);
	int Draw( int pass);

private:
	pMaterial mMaterial;
	float mSizex,mSizey;
};

typedef CSmartPtr<CPlain> pPlain;

#endif
