/***************************************************************************
 *   Copyright (C) 2006 by Paul-Louis Ageneau                              *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
// Constructeur
inline CPlane::CPlane(float _a,float _b,float _c,float _d) : a(_a),b(_b),c(_c),d(_d)
{

}

// Destructeur
inline CPlane::~CPlane(void)
{

}

inline CVector3 CPlane::Normal(void)
{
	return CVector3(a,b,c);
}

inline float CPlane::Norm(void) const
{
	return std::sqrt(a*a + b*b + c*c);
}

inline CPlane &CPlane::Normalize(void)
{
	float norm = Norm();
	
	if(norm > std::numeric_limits<float>::epsilon())
    {
        a /= norm;
        b /= norm;
        c /= norm;
        d /= norm;
    }

	return *(this);
}

// cast en const float*
inline CPlane::operator const float*() const
{
    return &a;
}

// cast en float*
inline CPlane::operator float*()
{
    return &a;
}

