/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef POINTLIGHT_H
#define POINTLIGHT_H

#include "light.h"
#include "include.h"

// Classe CPointLight
class CPointLight : public ILight
{	
public:
	CPointLight(void);		// Constructeur
	~CPointLight(void);		// Destructeur

	void setAttenuation(float constant,float linear,float quadratic);
	void setExponent(float exponent);
	void setCutoff(float cutoff);

	int Draw(int pass);

private:
	float mAttenuation[3];
	float mExponent;
	float mCutoff;

};

typedef CSmartPtr<CPointLight> pPointLight;

#endif	// POINTLIGHT_H
