/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef QUATERNION_H
#define QUATERNION_H

#include "include.h"
#include "vector3.h"

class CMatrix4;

class CQuaternion
{
public:
 
	// Constructeur par dfaut
	CQuaternion(void);
	// Constructeur surcharg
	CQuaternion(float _x,float _y,float _z,float _w);
	// Constructeur  partir d'un axe et d'un angle
	CQuaternion(const CVector3 &axe,float angle);
	// Constructeur  partir d'un matrice
	CQuaternion(const CMatrix4 &matrix);
	// Constructeur  partir des angles d'Euler
	CQuaternion(float x,float y,float z);
	// Constructeur  partir d'une direction
	CQuaternion(const CVector3 &direction);

	CQuaternion(const std::string &s);
	
	// Destructeur
	~CQuaternion(void);
	
	void Identity(void);
	float Norm(void) const;
	CQuaternion &Normalize(void);
	
	void FromAxis(const CVector3 &axe,float angle);
	void FromEuler(float x,float y,float z);
	void FromMatrix(CMatrix4 matrix);
	void FromDirection(const CVector3 &direction);
	
	// Multiplication
	CQuaternion operator*(const CQuaternion &q) const;
	CQuaternion operator/(CQuaternion q) const;
	CQuaternion &operator*=(const CQuaternion &q);

	float getAngle(void) const;
	CVector3 getAxis(void) const;
	CMatrix4 ToMatrix(void) const;
	
	float getEulerX(void) const;
	float getEulerY(void) const;
	float getEulerZ(void) const;

	CQuaternion Power(float t) const;
	CQuaternion Conjugate(void) const;
	CQuaternion Lerp(CQuaternion q,float t) const;

	// Donnes membres
	float x,y,z,w;
};

inline std::istream &operator >>(std::istream &in,CQuaternion &q)
{
	CVector3 v;
	float a;
	in>>v;
	a = getangle(in);
	q.FromAxis(v,a);
	return in;
}

inline CQuaternion::CQuaternion(const std::string &s)
{
	std::stringstream ss(s);
	ss>>*this;
}

#include "matrix4.h"
#include "quaternion.inl"

#endif // QUATERNION_H
