/***************************************************************************
 *   Copyright (C) 2006 by Paul-Louis Ageneau                              *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


// Renvoie un pointeur sur une ressource dj charge (NULL si non trouve)
template <class T>
inline CSmartPtr<T> CResourceManager::Get(const std::string& name) const
{
    // Recherche de la ressource
    ResourcesMap_t::const_iterator it = mResources.find(name);

    // Si on l'a trouve on la renvoie, sinon on renvoie NULL
    if (it != mResources.end()) return CSmartPtr<T>(it->second);
    else return NULL;
}
