/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "sample.h"
#include "exception.h"


CSample::CSample(void)
{
	alGenBuffers(1,&mBuffer);
}

CSample::CSample(const void *data, ALenum format, ALsizei size, ALsizei frequency)
{
	alGenBuffers(1,&mBuffer);
	alBufferData(mBuffer,format,data,size,frequency);
	CheckError();
}

CSample::~CSample(void)
{
	alDeleteBuffers(1,&mBuffer);
}

void CSample::Play(ALuint source,bool loop)
{
	ALenum state;
	alGetSourcei(source,AL_SOURCE_STATE,&state);
	if(state==AL_PLAYING) alSourceStop(source);
	
	//ALuint dummy;
	//alSourceUnqueueBuffers(source,1,&dummy);
	alSourcei(source,AL_LOOPING,loop);
	alSourceQueueBuffers(source,1,&mBuffer);
	CheckError();
	alSourcePlay(source);
	CheckError();

}

void CSample::Stop(ALuint source)
{
	alSourceStop(source);
}

bool CSample::Update(ALuint source)
{
	// rien  faire
	return true;
}

void CSample::CheckError(void) const
{
    int error=alGetError();
    // TODO URGENT: lance des exceptions sans arrt alors que tout marche !
	//if(error != AL_NO_ERROR) 
	//throw CException(std::string("Erreur OpenAL: ")+alGetString(error));
}
