/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef SAMPLE_H
#define SAMPLE_H

#if defined(_WIN32) || defined(_WIN64)
	#include "AL/al.h"
	#include "AL/alc.h"
#else
	#include <AL/al.h>
	#include <AL/alc.h>
#endif

#include "resource.h"
#include "include.h"

class CSample : public IResource
{
public:
	CSample(void);
	CSample(const void *data, ALenum format, ALsizei size, ALsizei frequency);
	~CSample(void);

	virtual void Play(ALuint source,bool loop);
	virtual void Stop(ALuint source);
	virtual bool Update(ALuint source);

protected:
	void CheckError(void) const;

	ALuint	mBuffer;
};

typedef CSmartPtr<CSample> pSample;

#endif
