/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef SCENE_H
#define SCENE_H

#include "camera.h"
#include "object.h"
#include "texture.h"
#include "light.h"
#include "entity.h"
#include "particle.h"
#include "plane.h"
#include "color.h"
#include "smartptr.h"
#include "include.h"

class CScene;
typedef CSmartPtr<CScene> pScene;

// Classe Scene
class CScene : public IRefCount
{
public:
	CScene(void);
	~CScene(void);

	static pScene Current;
	
	void setFogColor(const CColor &c);
	void setFogDistance(float n,float f);
	void setBackground(pTexture front,pTexture back,pTexture right,pTexture left,pTexture top,pTexture bottom);
	void setClipPlane(const CPlane *plane,int unit=0);
	
	pEntity getRootEntity(void);
	void Update(double time);
	int RenderBackground(void);
	int Render(void);

	void AddParticle(pParticle particle);
	void RegisterShadowLight(pLight light);
	void RegisterShadowCaster(pObject object);

private:
	int DrawShadows(void);
	int DrawParticles(pFrustum frustum);
	
	CColor	mfogColor;
	float	mfogNear,mfogFar;
	pTexture	mFront,mBack,mRight,mLeft,mTop,mBottom;
	pEntity		mRoot;					// Pointeur sur l'entite racine de la scne

	typedef std::map<int,CPlane> ClipPlaneMap_t;
	ClipPlaneMap_t mClipPlanes;
	
	typedef std::vector<pParticle> ParticlesList_t;
	ParticlesList_t mParticles;

	typedef std::vector<pLight> ShadowLightsList_t;
	ShadowLightsList_t mShadowLights;
	
	typedef std::vector<pObject> ShadowCastersList_t;
	ShadowCastersList_t mShadowCasters;
};

#endif
