/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef SCRIPTABLE_H
#define SCRIPTABLE_H

#include "script.h"
#include "smartptr.h"
#include "include.h"

class IScriptable;
typedef CSmartPtr<IScriptable> pScriptable;

class IScriptable : virtual public IRefCount
{
public:	
	IScriptable(void) {}					// Constructeur
	virtual ~IScriptable(void) {}			// Destructeur
	
	inline std::string &getScript(void) {return mScript;}
	
	void Script(const std::string &filename);
	void Script(pScript script);				// TODO: ne sauvegarde pas le nom de script
	void Script(std::istream &in);
	
	virtual pScriptable Tag(const std::string &tag)=0;
	virtual void Parameter(const std::string &tag,const std::string &data)=0;

private:
	std::string mScript;
};

#endif
