/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef SINGLETON_H
#define SINGLETON_H

#include "include.h"

template <class T> class ISingleton
{
public :

    static T *Instance()
    {
        if (!Inst)
            Inst = new T;

        return Inst;
    }

    static void Destroy()
    {
        delete Inst;
        Inst = NULL;
    }

protected :

    ISingleton() {}
    ~ISingleton() {}

private:

	static T* Inst;	// instance unique du singleton
};

template <class T> T *ISingleton<T>::Inst = NULL;

#endif
