/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef TEXT_H
#define TEXT_H

#include "entity.h"
#include "material.h"
#include "scene.h"
#include "include.h"

class CText : public CEntity
{
public:
	static void Init(void);
	static void Cleanup(void);
	
	CText(void);
	CText(const std::string &text,pMaterial font=NULL,bool center=false);
	virtual ~CText(void);

	void setFont(pMaterial font,float width=10.f,float height=20.f);
	pMaterial getFont(void) const;
	void setText(const std::string &text);
	const std::string &getText(void) const;
	void setCentered(bool center);

	virtual int Draw( int pass);

protected:
	static GLuint mLists;

	void updateTextRadius(void);

	std::string	mText;
	pMaterial	mFont;
	float		mWidth,mHeight;
	bool		mCenter;
};

typedef CSmartPtr<CText> pText;


#endif
