/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef TEXTURE_H
#define TEXTURE_H

#include "image.h"
#include "resource.h"
#include "smartptr.h"
#include "include.h"

class CTexture : public IResource
{
public:
	// Constructeur
	CTexture(pImage image);
	
	// Destructeur
	virtual ~CTexture(void);

	virtual void Bind(GLint wrap=GL_REPEAT);
	virtual void Unbind(void);

protected:
	GLuint		mTexNbr;
	GLuint		mTarget;
};

typedef CSmartPtr<CTexture> pTexture;

#endif
