/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "vorbisstream.h"
#include "exception.h"

CVorbisStream::CVorbisStream(const std::string &filename)
{
	FILE *file=fopen(filename.c_str(),"rb");
	if(!file) throw CLoadingFailed(filename, "Le fichier n'existe pas");

	if(ov_open(file,&mVorbisStream,NULL,0)<0)
	{
        fclose(file);
		throw CLoadingFailed(filename, "Format du fichier incorrect");
	}

	vorbis_info *vorbisInfo=ov_info(&mVorbisStream,-1);

	if(vorbisInfo->channels==1) mFormat = AL_FORMAT_MONO16;
    	else mFormat = AL_FORMAT_STEREO16;
	mRate=vorbisInfo->rate;
}

CVorbisStream::~CVorbisStream(void)
{
	ov_clear(&mVorbisStream);
}

int CVorbisStream::Fill(char *buffer, int size)
{
	int  written=0;
	int  section;
 
	while(written < size)
	{
		// TODO: endianess
		int result=ov_read(&mVorbisStream,buffer+written,size-written,0,2,1,&section);

		if(result>0) written+=result;
		else if(result<0) throw CException(VorbisErrorString(result));
		else {
			ov_raw_seek(&mVorbisStream,0);
			if(written>0) break;
		}
	}

	return written;
}

std::string CVorbisStream::VorbisErrorString(int code) const
{
	std::string s("Erreur Ogg Vorbis: ");
	switch(code)
	{
        case OV_EREAD:
            return s+"Erreur de lecture";
        case OV_ENOTVORBIS:
            return s+"Mauvais type de donnes";
        case OV_EVERSION:
            return s+"Mauvaise version";
        case OV_EBADHEADER:
            return s+"Header invalide";
        case OV_EFAULT:
            return s+"Erreur interne";
        default:
            return s+"Erreur inconnue";
	}
}
