/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef VORBIS_H
#define VORBIS_H

#if defined(_WIN32) || defined(_WIN64)
	#include "ogg/ogg.h"
	#include "vorbis/codec.h"
	#include "vorbis/vorbisenc.h"
	#include "vorbis/vorbisfile.h"
#else
	#include <ogg/ogg.h>
	#include <vorbis/codec.h>
	#include <vorbis/vorbisenc.h>
	#include <vorbis/vorbisfile.h>
#endif

#include "music.h"
#include "include.h"

class CVorbisStream : public CMusic
{
public:
	CVorbisStream(const std::string &filename);
	~CVorbisStream(void);
 
private:
	int Fill(char *buffer,int size);
	std::string VorbisErrorString(int code) const;

	OggVorbis_File  mVorbisStream;
 
};

typedef CSmartPtr<CVorbisStream> pVorbisStream;

#endif
