/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "bot.h"
#include "game.h"


extern pGame Game;

CBot::CBot(void)
{

}

CBot::~CBot(void)
{

}

void CBot::ServerUpdate(double time)
{
	usercmd_t cmd = getCommand();
	
	cmd.stick.z = 1.f;
	cmd.buttons = 0x0;

	CCoord3 position = getLocalMatrix().getTranslation();
	CQuaternion rotation = getLocalMatrix().getRotation();	
	CVector3 dirx = getLocalMatrix().getAxisX().Normalize();
	CVector3 diry = getLocalMatrix().getAxisY().Normalize();
	CVector3 dirz = getLocalMatrix().getAxisZ().Normalize();

	position+= diry*mWeaponHeight;
	
	// Slection de la cible
	float dist = std::numeric_limits<float>::infinity();
	CVector3 direction;
	for(CGame::NetEntitiesMap_t::iterator it=Game->mNetEntities.begin(); it!=Game->mNetEntities.end(); ++it)
	{
		if(it->first >= INDEX_NONPLAYER) break;
		
		pPlayer player = it->second;
		if(player->getGroup() == getGroup() || player->isDead()) continue;
		
		CVector3 target = player->getGlobalMatrix().getTranslation();
		float d = position.Distance(target);
		target+= player->getVelocity()*d/3000.f;
		d = position.Distance(target);
		
		if(d < dist) 
		{
			dist = d;
			direction = target-position;
		}
	}

	// Slection de l'approche
	float dfront = (dirz*direction.Norm()).Distance(direction);
	float dright = (-dirx*direction.Norm()).Distance(direction);
	float dleft = (dirx*direction.Norm()).Distance(direction);
	if(mWeapon[1].empty()) dfront = std::numeric_limits<float>::infinity();
	float dmin = std::min(dfront,std::min(dright,dleft))+EPSILON;
	
	if(dist <= 7500.f)
	{
		if(dright <= dmin && !mWeapon[3].empty())		direction = direction/10-direction.Crosspoint(CVector3(0.f,1.f,0.f));
		else if(dleft <= dmin && !mWeapon[2].empty())	direction = direction/10+direction.Crosspoint(CVector3(0.f,1.f,0.f));
	}
	
	direction.Normalize();
	float pitch = (dirz.y-direction.y)*30.f;
	float yaw = std::atan2(direction.x,direction.z) - std::atan2(dirz.x,dirz.z);
	yaw*=4.f/PI;
		
	if(dist <= 1200.f)
	{
		yaw = -yaw;
		pitch = -pitch;
	}
	
	float t = 1.f-std::exp(-float(time)*4.f);
	cmd.stick.x+=-(yaw+cmd.stick.x)*t;
	cmd.stick.y+=-(pitch+cmd.stick.y)*t;
	
	if(cmd.stick.x < -1.f) cmd.stick.x = -1.f;
	else if(cmd.stick.x > 1.f) cmd.stick.x = 1.f;
	if(cmd.stick.y < -1.f) cmd.stick.y = -1.f;
	else if(cmd.stick.y > 1.f) cmd.stick.y = 1.f;
	if(cmd.stick.z < 0.f) cmd.stick.z = 0.f;
	else if(cmd.stick.z > 1.f) cmd.stick.z = 1.f;
	
	if(dist <= 10000.f)
	{
		if(dright<300.f)		cmd.buttons|=0x10;
		else if(dleft<300.f)	cmd.buttons|=0x08;
		else if(dfront<40.f)	cmd.buttons|=0x01;
	}
	
	setCommand(cmd);
	CPlayer::ServerUpdate(time);
}

