/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef GAME_H
#define GAME_H

#include "netentity.h"
#include "player.h"
#include "main.h"

#define MAGIC			('P' + ('A'<<8))

#define INDEX_BOTS 8
#define INDEX_NONPLAYER 32

#define COLOR_NORMAL	CColor(0,0,0)
#define COLOR_NOTIF	CColor(255,0,0)
#define COLOR_EVENT	CColor(0,0,255)

class CGame : public IEngineState
{
public:
	CGame(void);
	~CGame(void);
	
	void setPlayer(const std::string &team,const std::string &plane,const std::string &option);
	
	virtual void Init(void);
	virtual void Cleanup(void);
		
	virtual bool Update(double time);
	virtual int Draw(void);
	
	void ChangeMusic(const std::string &music,int nbr);
	void Write(const std::string &message,const CColor &color=COLOR_NORMAL);
	
	void KeyCallback(int key,int action);
	void CharCallback(int key,int action);
	void MouseCallback(int button,int action);

	virtual bool Process(const std::string &command,const std::string &data="");

public:	// TODO
	pNetEntity getNetEntity(int object);
	
	pScene		mInterface;
	pScene		mScene;

	pPlayer		mTargetCamera;
	pCamera		mCamera;
	pObject		mTerrainObject;
	pTerrain	mTerrain;

	pEntity		mMap;
	pEntity		mMapCursors;
	pEntity		mMapGears[3];
	pEntity		mPointers[2];

	pEntity		mTextRoot;
	pText		mTyping;
	pText		mLastText;

	typedef std::map<int,pNetEntity> NetEntitiesMap_t;
	NetEntitiesMap_t mNetEntities;

protected:
	void SampleInput(usercmd_t &cmd,double time);
	void UpdateCamera(const usercmd_t &cmd,double time);

private:
	// Paramtres de camra
	float mCamAnglex,mCamAngley;
	int mCamMode;
	int mCamLock;

	// Musique
	pSound		mCurrentMusic,mNextMusic,mQueuedMusic;
	float		mMusicTransition;
	std::string	mLastMusicName;

	float	mMusicVolume;
};

typedef CSmartPtr<CGame> pGame;

#endif // GAME_H
