/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "select.h"
#include "game.h"
#include "client.h"
#include "server.h"
#include "main.h"

pGame Game=NULL;

int main(void)
{
	try
	{
		char r;
		std::string host;
		std::string name;
		int nbots[4];
		
		std::cout<<"Les pirates des cieux ";
		std::cout<<VERSION_MAJOR<<'.'<<VERSION_MINOR<<'.'<<VERSION_BUILD<<std::endl;
		std::cout<<"par Paul-Louis Ageneau"<<std::endl<<std::endl;

		std::cout<<"Entrez votre pseudo>";
		std::getline(std::cin,name);
		std::cout<<"Rejoindre(r) ou creer(c) une partie ?>";
		std::cin>>r;

		#if defined(_WIN32) || defined(_WIN64)
		WSADATA wsaData;
		WSAStartup(MAKEWORD(1,1),&wsaData);
		#endif
		
		if(r!='c')
		{
			std::cout<<"Adresse de l'hote>";
			std::cin>>host;
			for(int i=0;i<4;++i) nbots[i]=0;
			Game=new CClient(host);
		}
		else {
			std::cout<<"Personaliser la partie ? (o/n)>";
			std::cin>>r;
			
			if(r=='o')
			{
				std::cout<<"Nombre de bots:\n";
				std::cout<<"  Equipe imperiale: avions>";
				std::cin>>nbots[0];
				std::cout<<"                    zeppelins>";
				std::cin>>nbots[1];
				std::cout<<"  Equipe pirate: avions>";
				std::cin>>nbots[2];
				std::cout<<"                 zeppelins>";
				std::cin>>nbots[3];
			}
			else {
				for(int i=0;i<4;++i) nbots[i]=2;
			}
			
			Game=new CServer();
		}

		std::cout<<"Lancement du moteur..."<<std::endl;
		Engine->Init();
		MediaManager->AddPath("media");
		MediaManager->AddPath("media/objects");
		MediaManager->AddPath("media/map");

#ifdef DEBUG
		Engine->OpenWindow(640,480,false);
#else
		Engine->OpenWindow(1024,768,true);
		Engine->setCursor(false);
#endif
		Engine->setWindowTitle("Avions");
		
		std::cout<<std::endl<<"Chargement..."<<std::endl;
		Game->Process("NAME",name);
		Engine->PushState(Game);
		
		while(nbots[0]-- > 0) pServer(Game)->AddBot("empire","avion");
		while(nbots[2]-- > 0) pServer(Game)->AddBot("pirate","avion");
		while(nbots[1]-- > 0) pServer(Game)->AddBot("empire","dirigeable");
		while(nbots[3]-- > 0) pServer(Game)->AddBot("pirate","dirigeable");
		
		std::cout<<"Debut de la boucle principale..."<<std::endl;
		
		double oldtime = Engine->getTime();
		while(Engine->Update())
		{
			//std::cout<<"Update: "<<int((Engine->getTime()-oldtime)*1000)<<" ms\t";
			
			oldtime = Engine->getTime();
			int polys=Engine->Display();
			
			//std::cout<<"Display: "<<int((Engine->getTime()-oldtime)*1000)<<" ms\t";
			//std::cout<<polys<<" polys\t@ "<<Engine->getFPS()<<" FPS"<<std::endl;
			oldtime = Engine->getTime();
		}

		Game=NULL;
		Engine->Cleanup();
	}
	catch(const std::exception &e)
	{
		Game=NULL;
		Engine->Cleanup();

		std::cout<<"Erreur: "<<e.what()<<std::endl;
		char dummy;
		std::cin>>dummy;
	}

	#if defined(_WIN32) || defined(_WIN64)
	WSACleanup();
	#endif

	return EXIT_SUCCESS;
}
