/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef NETENTITY_H
#define NETENTITY_H

#include "main.h"

#define DATA_NOTHING		0x00
#define DATA_CREATE			0x01
#define DATA_STATUS			0x02
#define DATA_COMMAND		0x04
#define DATA_PLAYER			0x08
#define DATA_POSITION		0x10
#define DATA_VELOCITY		0x20
#define DATA_ROTATION		0x40
#define DATA_LATENCY		0x80
#define DATA_CLIENT			(DATA_COMMAND|DATA_POSITION|DATA_VELOCITY|DATA_ROTATION)
#define MAX_DATA_FLAGS		8

#define EVENT_SHOOT			0x01
//#define EVENTS_BACKLOG		5.

struct usercmd_t
{
	CVector3 stick;		// inclinaison du joystick
	CVector3 stickAux;	// inclinaison du joystick auxiliaire
	unsigned buttons;	// flags de pression des boutons
	
	unsigned changed;	// flags de changement
						// ATTENTION: non transmis par le rseau pour l'instant !
};

struct event_t
{
	double stamp;		// timestamp
	int id;				// identifiant de l'vnement
	int param;			// paramtre optionnel
};

class CNetEntity;
typedef CSmartPtr<CNetEntity> pNetEntity;

class CNetEntity : public CEntity
{
public:
	CNetEntity(void);
	virtual ~CNetEntity(void);
	
	void setIdentifier(int identifier);
	int getIdentifier(void) const;
	
	void setGroup(const std::string &group);
	void resetGroup(void);
	void setName(const std::string &name);
	const std::string &getGroup(void) const;
	const std::string &getName(void) const;
	void setNameVisibility(bool visible);
	
	virtual float getRadius(void) const;

	// Entres-Sorties
	virtual void Input(int flags,buffer_t &data);
	virtual void OutputData(int flags,buffer_t &data);
	//void OutputEvents(double stamp,buffer_t &data);
	void Input(double latency,int flags,buffer_t &data);
	double getLatency(void) const;
	
	void setCommand(const usercmd_t & cmd);
	void resetCommand(void);
	const usercmd_t &getCommand(void) const;

	CVector3 getCorrective(double time);
	
	// Mises  jour
	virtual bool Update(double time);			// mises  jour graphiques
	virtual void ServerUpdate(double time);		// mises  jour du status
	virtual void ApplyCommand(const usercmd_t & cmd);
	virtual bool Event(const event_t &ev);

	// Routines de rponse
	// Rponse  l'entre en contact d'un projectile
	virtual void BulletResponse(pNetEntity owner,float damage,const CCoord3 &intersect,const CVector3 &direction);
	
	// TODO: interne
	void setChanged(int flags);
	int getChanged(double stamp) const;

	// Retourne le dcalage temporel local induit par les entites
	static double getTimeShift(const CCoord3 position);

	usercmd_t	mCommand;	// TODO

protected:
	float		mRadius;

private:
	int			mIdentifier;
	std::string	mGroup,mName;
	pText		mNameText;
	
	double		mLatency;
	CVector3	mCorrective;				// correctif de position

	// Backlog des vnements
	/*typedef std::map<double,event_t> EventsMap_t;
	EventsMap_t mEvents;*/

	double mLastChange[MAX_DATA_FLAGS];		// sauvegardes des stamps de mise  jour
};

#endif
