/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef PLAYER_H
#define PLAYER_H

#include "netentity.h"
#include "bullet.h"
#include "rocket.h"
#include "main.h"

#define STATUS_KILLED	0x01
#define STATUS_CRASHED	0x02

class CPlayer : public CNetEntity
{
public:
	CPlayer(void);
	virtual ~CPlayer(void);

	inline float getPowerFactor(void)			{ return mPower/mMaxPower; }
	inline float getHeatOfBattle(void)			{ return mHeatOfBattle; }
	inline const CVector3 &getVelocity(void)	{ return mVelocity; }
	inline bool isDead(void)					{ return (mStatus & STATUS_KILLED)!=0; }
	
	void setCursor(const std::string &texture);

	// Entres-Sorties
	virtual void Input(int flags,buffer_t &data);
	virtual void OutputData(int flags,buffer_t &data);

	// Scripts
	virtual void Parameter(const std::string &param,const std::string &data);
	
	// Mises  jour
	virtual bool Update(double time);
	virtual void ServerUpdate(double time);
	virtual void ApplyCommand(const usercmd_t & cmd);
	virtual bool Event(const event_t & ev);

	// Routines de rponse
	virtual int CollisionResponse(const CCoord3 &intersect,const CVector3 &normal);
	virtual void BulletResponse(pNetEntity owner,float damage,const CCoord3 &intersect,const CVector3 &direction);

protected:
	virtual bool ChangeStatus(unsigned status);

	std::string mWeapon[4];
	
	float		mMaxPower;
	float		mGravity;
	float		mBearing;
	float		mFriction;
	float		mRotateSpeed;
	float		mAntiRotateCoeff;
	float		mWeaponHeight;
	float		mStartLife;
	int			mWeapon2Nbr;
	
	pEmitter	mSmoke,mFire,mTail;
	pSound		mGun,mCannon;
	pPlain		mCursor;
	
	float		mPower;
	CVector3	mVelocity;
	unsigned	mStatus;
	unsigned	mShoot;
	float		mLife;	
	float		mCooldown;
	int			mShootId;
	float		mWait;

	float		mHeatOfBattle;

	// Variables de passage d'tat et d'vnements
	pNetEntity	mAttacker;
	float		mDamage;
	bool		mGroundCollision;
};


typedef CSmartPtr<CPlayer> pPlayer;

#endif
