/***************************************************************************
 *   Copyright (C) 2006 by Paul-Louis Ageneau                              *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/*
#include "rocket.h"

extern pGame Game;

CRocket::CRocket(pNetEntity owner)
{
	mSpeed = 150.f;
	mAccuracy = 2.f;
	mRadius = 1.f;
	mStartLife = 10.f;
	mTimer = 0.f;

	mOwner = owner;

	setLife(mStartLife);
}

CRocket::~CRocket(void)
{

}
	
void CRocket::Parameter(const std::string &param,const std::string &data)
{
	std::stringstream sdata(data);

	if(param == "speed")				sdata>>mSpeed;
	else if(param == "accuracy")		sdata>>mAccuracy;
	else if(param == "radius")			sdata>>mRadius;
	else if(param == "life")			{sdata>>mStartLife; setLife(mStartLife);}
	else CEntity::Parameter(param,data);
}

void CRocket::ServerUpdate(double time,double stamp)
{
	CVector3 move = getLocalMatrix().getAxisZ().Normalize()*mSpeed*time;
	CCoord3 pos = getLocalMatrix().getTranslation();
	CQuaternion rotation = getLocalMatrix().getRotation();
	
	float t = Game->mTerrainObject->Intersection(pos,move,mRadius,NULL);
	if(t>=0.f && t<=1.f)
	{
		pEntity impact = new CEntity("fx/impact.p3d");
		impact->Translate(pos+move*t);
		impact->Attach(getFather());
		Detach();
		return;
	}
	
	float tmin = std::numeric_limits<float>::infinity();
	float dist = std::numeric_limits<float>::infinity();
	
	pNetEntity nearest = NULL;
	pNetEntity collision = NULL;
	CVector3 u(move);
	u.Normalize();
	for(CGame::NetEntitiesMap_t::iterator it=Game->mNetEntities.begin(); it!=Game->mNetEntities.end(); ++it)
	{
		if(it->first >= INDEX_NONPLAYER) break;
		if(it->second->getGroup() == getGroup()) continue;
		
		float d =	it->second->getLocalMatrix().getTranslation().Distance(pos)
					-(it->second->getLocalMatrix().getTranslation()-pos).Dotpoint(u);

		if(d<dist)
		{
			dist = d;
			nearest = it->second;
		}
		
		t = it->second->Intersection(pos,move,mRadius,NULL);
		if(t>=0.f && t<=tmin)
		{
			tmin = t;
			collision = it->second;
		}
	}

	if(tmin<=1.f && mTimer>0.25f)
	{
		nearest->BulletResponse(mOwner,40.f,pos+move*tmin,move);
		Detach();
	}
	
	if(nearest != NULL)
	{
		CVector3 direction = nearest->getLocalMatrix().getTranslation()-pos;
		mTimer+=time;
		t = 1.f-std::exp(-mAccuracy*time);
		t*=std::min(1.f,(std::exp(mTimer)-1.f)/(std::exp(mStartLife*0.2f)-1.f));
		rotation = rotation.Lerp(CVector3(direction),t);
	}
	
	Translate(CVector3(0.f,0.f,mSpeed*time));
	pos = getLocalMatrix().getTranslation();

	Identity();
	Translate(pos);
	Rotate(rotation);
}
*/
