/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#include "select.h"
#include "game.h"

extern pGame Game;

CSelect::CSelect(void)
{
	mTeam = "empire";
	mPlane = "avion";
}

CSelect::~CSelect(void)
{

}
	
void CSelect::Init(void)
{
	mScene=new CScene;
	mScene->setBackground( MediaManager->Get<CTexture>("sky/front.jpg"),
				MediaManager->Get<CTexture>("sky/back.jpg"),
				MediaManager->Get<CTexture>("sky/right.jpg"),
				MediaManager->Get<CTexture>("sky/left.jpg"),
				MediaManager->Get<CTexture>("sky/up.jpg"),
				NULL);
	
	mScene->setFogColor(CColor(255,255,255));
	mScene->setFogDistance(1400.f,2000.f);

	mCamera=new CCamera;
	mCamera->Translate(CVector3(0.f,0.f,400.f));
	mCamera->Attach(mScene->getRootEntity());
	mCamera->setRange(0.1f,1000.f);
	
	pLight light=new CPointLight;
	light->Translate(CVector3(-100.f,100.f,100.f));
	light->Attach(mScene->getRootEntity());
	light->CastShadow(true);
	
	mFlag = new CObject(MediaManager->Get<CMesh>("objects/flag.md2"));
	mFlag->Translate(CVector3(-80.f,0.f,-200.f));
	mFlag->Scale(CVector3(6.f,6.f,6.f));
	mFlag->Rotate(CQuaternion(CVector3(0.f,1.f,0.f),PI/2.5f));
	mFlag->Rotate(CQuaternion(CVector3(1.f,0.f,0.f),-PI/2));
	mFlag->Attach(mScene->getRootEntity());
	mFlag->setAnimationSpeed(5.);
	mFlag->PlayAnimation();
	
	Reload();
}

void CSelect::Cleanup(void)
{

}
		
bool CSelect::Update(double time)
{
	Game->Update(time);
	
	if(isKeyDown(KEY_ENTER) || isMouseButtonDown(MOUSE_BUTTON_LEFT))
	{
		Game->Process("JOIN");
		return false;
	}
	
	mScene->Update(time);
	mObject->Rotate(CQuaternion(CVector3(0.f,1.f,0.f),time*0.5f));
	return true;
}

int CSelect::Draw(void)
{
	mCamera->Clear(CColor(0.5f,0.5f,75.f));
	mCamera->Apply();

	int polys=0;
	polys+=mScene->RenderBackground();
	polys+=mScene->Render();
	
	//CCamera::Default->Apply();
	//polys+=mInterface->Render();

	return polys;
}
	
void CSelect::Reload(void)
{
	std::string filename = "objects/"+mTeam;
	mFlag->setMaterial(new CMaterial(MediaManager->Get<CTexture>(filename+".png")));
	filename+="/"+mPlane+".p3d";

	if(mObject != NULL) mObject->Attach(NULL);
	mObject = new CEntity(filename);
	mObject->Attach(mScene->getRootEntity());
	mObject->PlayAnimation();

	Game->Process("TEAM",mTeam);
	Game->Process("PLANE",mPlane);
}

void CSelect::KeyCallback(int key,int action)
{
	if(action == KEY_PRESS)
	{
		switch(key)
		{
		// TODO: utiliser un compteur
		case KEY_RIGHT:	
			if(mPlane=="avion") mPlane="dirigeable";
			else mPlane="avion";
			break;

		case KEY_LEFT:
			if(mPlane=="avion") mPlane="avion";
			else mPlane="avion";
			break;

		case KEY_DOWN:
		case KEY_UP:
			if(mTeam=="pirate") mTeam = "empire";
			else mTeam="pirate";
			break;

		default:
			return;
		}

		Reload();
	}
}

void CSelect::MouseCallback(int button,int action)
{

}
