/***************************************************************************
 *   Copyright (C) 2006-2008 by Paul-Louis Ageneau                         *
 *   paullouisageneau@gmail.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.           *
 ***************************************************************************/

#ifndef SELECT_H
#define SELECT_H

#include "main.h"

class CSelect : public IEngineState
{
public:
	CSelect(void);
	~CSelect(void);
	
	virtual void Init(void);
	virtual void Cleanup(void);
		
	virtual bool Update(double time);
	virtual int Draw(void);
	
	void KeyCallback(int key,int action);
	void MouseCallback(int button,int action);

public:
	void Reload(void);
	std::string mTeam;
	std::string mPlane;

	//pScene		mInterface;
	pScene		mScene;
	pCamera		mCamera;
	pEntity		mObject;
	pObject		mFlag;
};

typedef CSmartPtr<CSelect> pSelect;

#endif // SELECT_H
