/* Public domain: use this file as you wish. NO WARRANTY. */
/* Written in 2013 by Alexandru Cojocaru <xojoc@gmx.com> */

#pragma once
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <stdint.h>
enum pjson_type {
	PJSON_LITERAL,
	PJSON_STRING,
	PJSON_NUMBER,
	PJSON_OBJECT,
	PJSON_ARRAY,
};
enum pjson_err {
	PJSON_EOF = -5,
	PJSON_ERR,
	PJSON_WARN,
	PJSON_EMEM,
	PJSON_BARG,
};
struct pjson_parser {
	/* external */
	char *buf;
	char *endp;

	void* (*malloc)(size_t s);
	void (*free)(void *);

	enum pjson_err err;
	char *strerr;
	
	FILE * pp_out;
	size_t pp_incind;
	size_t pp_ind;

	/* internal */
	char *ptr;
};
struct pjson_token {
	union {
		char *str;
		float num;
		char lit;
		struct pjson_token *val;
	};

	union {
		size_t strsz;
		struct pjson_token *key;
	};

	/* Next object member or array element. */
	struct pjson_token *next;

	enum pjson_type type;
};
void pjson_init_parser (struct pjson_parser *p, char *buf, size_t len);
struct pjson_token * pjson_parse (struct pjson_parser *p);
enum pjson_err pjson_check (struct pjson_parser *p);
void pjson_pprint (struct pjson_parser *p, struct pjson_token *r);
