#!/bin/sh

# Copyright (C) 2004 Mark Seaborn
#
# This file is part of Parser Generator.
#
# Parser Generator is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2, or (at
# your option) any later version.
#
# Parser Generator is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Parser Generator; see the file COPYING.  If not, write
# to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
# Boston, MA 02111-1307 USA.


set -e

auto_gen_msg () {
  echo '(* This file is automatically generated *)'
  echo
  echo
}

OPENS="--open StdLabels --open My_utils --open Pexprs"

ocamlc -c my_utils.ml parser_runtime.ml
ocamlc pexprs.ml expand_out.ml generator.ml gram_bootstrap.ml -o gram_bootstrap

(auto_gen_msg; ./gram_bootstrap) > gram_out0.ml

(auto_gen_msg; perl -ne 's/Gram_out/Gram_out0/; print $_') <compile_grammar.ml >compile_grammar0.ml
ocamlc my_utils.cmo parser_runtime.cmo expand_out.cmo generator.cmo \
	gram_out0.ml compile_grammar0.ml -o compile_grammar0

./compile_grammar0 $OPENS gram.gram > gram_out1.ml

(auto_gen_msg; perl -ne 's/Gram_out/Gram_out1/; print $_') <compile_grammar.ml >compile_grammar1.ml
ocamlc my_utils.cmo parser_runtime.cmo expand_out.cmo generator.cmo \
	gram_out1.ml compile_grammar1.ml -o compile_grammar1

./compile_grammar1 $OPENS gram.gram > gram_out2.ml



# Build C code generator

ocamlc -c c_generator.ml
# This is now customised, not auto-generated.
# perl -ne 's/Gram_out/Gram_out1/; s/Generator/C_generator/; print $_' <compile_grammar.ml >c_compile_grammar.ml
ocamlc my_utils.cmo parser_runtime.cmo expand_out.cmo c_generator.cmo \
	gram_out1.ml c_compile_grammar.ml -o c_compile_grammar

./c_compile_grammar gram.gram > gram_out_c.c
gcc gram_out_c.c parser_driver.c -o parser_driver




ocamlc -c sh_exprs.ml
./compile_grammar1 --open Sh_exprs --open My_utils shell.gram > shell_out.ml
ocamlc -c shell_out.ml
