(* Copyright (C) 2004 Mark Seaborn

   This file is part of Parser Generator.

   Parser Generator is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   Parser Generator is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Parser Generator; see the file COPYING.  If not, write
   to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
   Boston, MA 02111-1307 USA.  *)


open StdLabels
open My_utils
open Parser_runtime

module G = Gram_out


let compile opens file =
  let str = with_input file ~f:input_all_string in
    match do_parse G.f_defs str with
      | OK(i, defs1) when i = String.length str ->
          let defs = ref [] in
            Expand_out.add_def defs "null" Pexprs.P_null;
            Expand_out.add_def defs "fail" Pexprs.P_fail;
            List.iter defs1
              ~f:(fun (v, exp) ->
                    Expand_out.add_def defs v
                      (Expand_out.simplify ~defs exp));
            Printf.printf "(* This file is automatically generated *)\n\n";
            List.iter opens ~f:(fun name -> Printf.printf "open %s\n" name);
            Generator.output stdout !defs
      | _ -> output_errors stderr

let _ =
  let prog_name::args = Array.to_list Sys.argv in
  let rec f opens = function
    | "--open"::name::rest -> f (name::opens) rest
    | [file] -> compile opens file
    | _ -> Printf.printf "Usage: %s input_file\n" prog_name
  in f [] args
