##########################################################################
#                                                                        #
#                  This file is part of PerlCoinCoin                     #
#           Copyright 2003 - Loc Restoux  <lordoric@free.fr>            #
#                                                                        #
#                                                                        #
# PerlCoinCoin is free software; you can redistribute it  and/or  modify #
# it under the terms of the GNU General Public License as  published  by #
# the Free Software Foundation; either version 2 of the License, or  (at #
# your option) any later version.                                        #
#                                                                        #
# Foobar is distributed in the hope that it will be useful, but  WITHOUT #
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY  or #
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General  Public  License #
# for more details.                                                      #
#                                                                        #
# You should have received a copy of  the  GNU  General  Public  License #
# along with Foobar; if not, write  to  the  Free  Software  Foundation, #
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA            #
#                                                                        #
##########################################################################
# 
# Curses::UI is (c) 2001-2002 by Maurice Makaay. All rights reserved.
# You can redistribute it and/or modify it under the same terms
# as perl itself.
#
# e-mail: maurice@gitaar.net
# ----------------------------------------------------------------------

package Curses::UI::Pinnipede;

use strict;
use HTML::Entities;   # decode
use List::Util;				# maxstr
use Curses;
use Curses::UI::Common;
use Curses::UI::Widget;
use Curses::UI::Searchable;
require Curses::UI::TextEditor;

use Plcc::PlccLogger;

use vars qw(
    $VERSION 
    @ISA
);

$VERSION = '0.10';

@ISA = qw(
    Curses::UI::TextEditor
);

sub new ()
{
	$PlccLogger::logger->debug("Debut");

    my $class = shift;
    my %userargs = @_;
    keys_to_lowercase(\%userargs);

		# Mes attributs  moi que j'ai
		my %args = (
			%userargs,
			-messages			=> {},
		);
		
    # Create the Widget.
    my $this = $class->SUPER::new( %userargs );

		# On supprime les bindings qu'on veut pas :
		$this->clear_binding( 'add-string' );
		$this->clear_binding( 'undo' );
		$this->clear_binding( 'delete-line' );
		$this->clear_binding( 'delete-till-eol' );
		$this->clear_binding( 'delete-character' );
		$this->clear_binding( 'paste' );
		$this->clear_binding( 'clear-line' );
		$this->clear_binding( 'backspace' );
		$this->clear_binding( 'newline' );

		# Dfinition des couleurs
		start_color();

	$PlccLogger::logger->debug("Fin");
	
    return $this;
}

sub renduMsg 
{
	$PlccLogger::logger->debug("Debut");

  my ($message) = @_;

	my $time = $message->{TIME};
	my $ua = "<-CY>".substr( decode_entities( $message->{INFO} ), 0, 10 );

	if ( $message->{LOGIN} and $message->{LOGIN} ne 'Anonyme' )
	{
		$ua = "<-CR>".$message->{LOGIN};
	}

	my $msg = decode_entities( $message->{MESSAGE} );
	
	# Achthmel
	$msg =~ s/<b>(.*?)<\/b>/<-B>$1<-\/B>/g;
	$msg =~ s/<i>(.*?)<\/i>/<-I>$1<-\/I>/g;
	$msg =~ s/<u>(.*?)<\/u>/<-U>$1<-\/U>/g;
	$msg =~ s/<s>(.*?)<\/s>/<-S>$1<-\/S>/g;
	$msg =~ s/<a href=\"(.*?)\">(.*?)<\/a>/<-CY><-B><-A$1>$2<-\/A><-\/B><-CN>/g;

	# Norloges
	# On jette pour le moment : a casse les [url] qui contiennent un truc ressemblant  une horloge
#	$msg =~ s/(\d{2}:?\d{2}(:?\d{2})?)/<-CY>$1<-CN>/g ;
	
	$PlccLogger::logger->debug("Fin");
	
	return 
		"<-CY>".substr( $time, 8, 2 ).":".substr( $time, 10, 2 ).":".substr( $time, 12, 2 )
		." $ua <-CN>$msg<-CN>" ;
}

sub addPosts 
{
 	$PlccLogger::logger->debug("Debut");

  my $this = shift;
	my (%post) = @_;
	my $texte = '';
	
	foreach my $id ( keys %post )
	{
		$this->{-messages}{ $id } = renduMsg( $post{ $id } );
	}

	foreach my $id ( sort { $a <=> $b } keys %{$this->{-messages}} )
	{
		$texte .= $this->{-messages}->{$id}."\n";
	}
	$this->{-text} = $texte;

	$PlccLogger::logger->debug("Texte final : $texte");

	$PlccLogger::logger->debug("Fin");
}

sub text_wrap($$;)
{
 	$PlccLogger::logger->debug("Debut");

	# Make $this->text_wrap() possible.
	shift if ref $_[0];
	my ($line, $maxlen) = @_;

	$PlccLogger::logger->debug("Ligne : $line");
	
	return [""] if $line eq '';

	my @wrapped = ();
	my $len = 0;
	my $wrap = '';

	my @liste = split ' ', $line;
	while ( @liste )
	{
		my $mot = shift @liste;
		my $mot_wo_textattr = $mot; 
		$mot_wo_textattr =~ s/<-(\/?(C.|B|U|I|S|A.*?))>//g ;
		my $len_mot = length( $mot_wo_textattr );
		
# Grer le mot trop long plz

		if ( $maxlen < $len + $len_mot + 1)
		{
			push @wrapped, $wrap;
			$wrap = "$mot ";
			$len = $len_mot;			
		} else {
			$wrap .= "$mot ";
			$len += $len_mot+1;
		}
	}

	push ( @wrapped, $wrap ) unless ( $wrap eq '' );
        
	$PlccLogger::logger->debug("Fin");
	
	return \@wrapped;
}

sub draw_text(;$)
{
 	$PlccLogger::logger->debug("Debut");
	
    my $this = shift;
    my $no_doupdate = shift || 0;
    return $this if $Curses::UI::screen_too_small;

    # Return immediately if this object is hidden.
    return $this if $this->hidden;

		init_pair(0, COLOR_WHITE, COLOR_BLACK);
		init_pair(1, COLOR_RED, COLOR_BLACK);
		init_pair(2, COLOR_YELLOW, COLOR_BLACK);

    # Turn on underlines and fill the screen with lines
    # if neccessary.
    if ($this->{-showlines})
    {
        $this->{-canvasscr}->attron(A_UNDERLINE);
        for my $y (0..$this->canvasheight-1) {
            $this->{-canvasscr}->addstr($y, 0, " "x($this->canvaswidth));
        }
    }

    # Draw the text.
    for my $id (0 .. $this->canvasheight - 1)
    {    
        my $l = $this->{-scr_lines}->[$id + $this->{-yscrpos}];

				$PlccLogger::logger->debug("Ligne $id : $l") if defined $l;

        if (defined $l)
        {
            # Clear line.
            $this->{-canvasscr}->addstr(
                $id, 0, 
								" "x$this->canvaswidth
	    			);

						my ($before, $balise, $bidon, $espace, $after);
						my $pos = 0;
						my $msg = $l;
						my $color;
						while ( ( $before, $espace, $balise, $bidon, $after ) = 
							( $msg =~ /(.*?)(\s+|<-(\/?(C.|B|U|I|S|A.*?))>)(.*)$/ ) )
						{
						
							# Impression du mot
							$this->{-canvasscr}->addstr($id, $pos, $before);
							$pos += length( $before );
							$pos++ if ( $espace eq ' ' );

							# Gestion de la balise ventuelle
							if ($balise )
							{
								$this->{-canvasscr}->attron(A_BOLD) if $balise eq 'B';
								$this->{-canvasscr}->attroff(A_BOLD) if $balise eq '/B';
								$this->{-canvasscr}->attron(A_UNDERLINE) if $balise eq 'U';
								$this->{-canvasscr}->attroff(A_UNDERLINE) if $balise eq '/U';
#								$this->{-canvasscr}->attron(A_DIM) if $balise eq 'S';
#								$this->{-canvasscr}->attroff(A_DIM) if $balise eq '/S';
								$this->{-canvasscr}->attron(A_BLINK) if $balise eq 'I';
								$this->{-canvasscr}->attroff(A_BLINK) if $balise eq '/I';
							}

							# Gestion des couleurs
							if ( $balise and ($color) = ( $balise =~ /C(.)/ ) )
							{
								$this->{-canvasscr}->attroff( COLOR_PAIR(0) ); 
								$this->{-canvasscr}->attroff( COLOR_PAIR(1) ); 
								$this->{-canvasscr}->attroff( COLOR_PAIR(2) ); 
								$this->{-canvasscr}->attron( COLOR_PAIR(0) ) if $color eq 'N';
								$this->{-canvasscr}->attron( COLOR_PAIR(1) ) if $color eq 'R';
								$this->{-canvasscr}->attron( COLOR_PAIR(2) ) if $color eq 'Y';
							}

							# La suite !
							$msg = $after;
						}

						$this->{-canvasscr}->addstr($id, $pos, $after) if $after;
		
				} else {
            last;
        }
    }

    # Move the cursor.
    # Take care of TAB's    
    my $l = $this->{-scr_lines}->[$this->{-ypos}];
    my $precursor = substr(
        $l, 
        $this->{-xscrpos},
        $this->{-xpos} - $this->{-xscrpos}
    );

    my $realxpos = scrlength($precursor);
    $this->{-canvasscr}->move(
       $this->{-ypos} - $this->{-yscrpos}, 
       $realxpos
    );
    
    $this->{-canvasscr}->attroff(A_UNDERLINE) if $this->{-showlines};
    $this->{-canvasscr}->noutrefresh();
    doupdate() unless $no_doupdate;
 	
	$PlccLogger::logger->debug("Fin");
	
    return $this;
}

1;
