##########################################################################
#                                                                        #
#                  This file is part of PerlCoinCoin                     #
#           Copyright 2003 - Loc Restoux  <lordoric@free.fr>            #
#                                                                        #
#                                                                        #
# PerlCoinCoin is free software; you can redistribute it  and/or  modify #
# it under the terms of the GNU General Public License as  published  by #
# the Free Software Foundation; either version 2 of the License, or  (at #
# your option) any later version.                                        #
#                                                                        #
# Foobar is distributed in the hope that it will be useful, but  WITHOUT #
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY  or #
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General  Public  License #
# for more details.                                                      #
#                                                                        #
# You should have received a copy of  the  GNU  General  Public  License #
# along with Foobar; if not, write  to  the  Free  Software  Foundation, #
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA            #
#                                                                        #
##########################################################################

package PlccGUI;

use strict;

use Plcc::PlccNet;
use Plcc::PlccGlobal;
use Plcc::PlccLogger;
use Curses::UI::Pinnipede;
use Curses::UI;
use Plcc::PlccLogger qw($logger);


our $cui;   # Fentre principale

sub traiteTO
{
	$PlccLogger::logger->debug("Debut");

	alarm 0;
	
	my %newPost = PlccNet::refreshBackend( );
	my $pinni = $cui->getobj('plcc')->getobj('pinni');
	$pinni->addPosts( %newPost );
	$pinni->pos( length( $pinni->text ) );
	
	alarm $PlccGlobal::minuterie;

	$PlccLogger::logger->debug("Fin");
}

sub about
{
	my ($cui) = @_;

	$PlccLogger::logger->debug("Dbut");
	$cui->dialog("PerlCoinCoin v$PlccGlobal::version\nlordOric - 2002\nMerci  Raymond, mon ornithorynque.");
	$PlccLogger::logger->debug("Fin");
}

sub shortcuts 
{
	my ($cui) = @_;

	$PlccLogger::logger->debug("Dbut");
	$cui->dialog("Raccourcis de touches :\n".
							 "Tabulations : passe du palmipde au pinnipde.\n".
							 "Entre : dans le palmipde, poste le message.\n".
							 "Ctrl-x : permet de rentrer dans le menu.\n".
							 "Ctrl-r : Rafraichit le pinnipde.\n".
							 "Ctrl-q : quitte.\n".
							 "\nN'oubliez pas que le rendu dpend de votre terminal, et qu' ce titre, il y a de fortes chances pour que votre souris soit supporte. \\o/"
							 );
	$PlccLogger::logger->debug("Fin");
}

sub create_edit_ua
{
	my ($cui) = @_;

	$PlccLogger::logger->debug("Dbut");

	my $win = $cui->add(
     'edit_ua', 'Window',
     -border => 1,
		 -title => "User-agent",
		 -x => 10,
		 -y => 10,
		 -height => 6,
		 -width => 60,
  );
	
	my $edit = $win->add(
		'edit', 'TextEntry',
		-sbborder => 1,
    -width => 60,
		-y => 1,
		-text => $PlccGlobal::myUA,
	);

	my $bouton = $win->add(
    undef, 'Buttonbox',
		-y => 3,   
		-x => 20,  
    -buttons => [
         {
            -label => "[Default]",
						-value => 0, 
  	  	    -onpress => sub{ $edit->text( $PlccGlobal::defautUA ); }, 
        },{
            -label => "[Ok]", 
						-value => 1, 
    		    -onpress => sub { $PlccGlobal::myUA = $edit->text; $cui->getobj('plcc')->focus() }, 
        },
    ],
	);

	$PlccLogger::logger->debug("Fin");
}

sub quitter
{
	my ($cui) = @_;

	$PlccLogger::logger->debug("Dbut");

	my $confirm = $cui->dialog(
		-message => "tes vous sr ?",
		-buttons => [
            { 
              -label => '[Oui]',
              -value => 1,
              -shortcut => 'o' 
            },{ 
              -label => '[Non]',
              -value => 0,
              -shortcut => 'n' 
            }
        ],
	 	-values  => [1,0],
  	-title   => 'Quitter',
	);

	if ($confirm) {
		$PlccLogger::logger->fatal("Sortie demande");
		exit();
	}
	
	$PlccLogger::logger->debug("Fin");
}

sub post
{
	my ($cui, $palmi) = @_;

	$PlccLogger::logger->debug("Dbut");

	my $confirm = $cui->dialog(
		-message => "tes vous sr ?",
		-buttons => [
            { 
              -label => '[Oui]',
              -value => 1,
              -shortcut => 'o' 
            },{ 
              -label => '[Non]',
              -value => 0,
              -shortcut => 'n' 
            }
        ],
	 	-values  => [1,0],
  	-title   => 'Poster',
	);

	if ($confirm) {
		alarm 0;
		PlccNet::post( $palmi->text );  # Va falloir forker ce truc l, surtout sur le comptoir. :/
		sleep 1;
		traiteTO();
		$palmi->text('');
	}

	$PlccLogger::logger->debug("Fin");
}

sub launchGUI 
{
	my (%tribune) = @_;

	$PlccLogger::logger->debug("Dbut");
	
	# Initialise the environment
	my $cui= new Curses::UI(
		-clear_on_exit => 1,
	);

	# Le menu
	my $pl_menu = [ { -label => 'Quit', 				-value => sub{ quitter( $cui ) }} ];
	my $doit_menu = [ { -label => 'Modifier UA',-value => sub{ $cui->getobj('edit_ua')->focus() } },
										{ -label => 'Rafraichir', -value => sub{ traiteTO() } } ];
	my $aide_menu = [ { -label => 'Raccourcis', -value => sub{ shortcuts( $cui ) } },
										{ -label => ' propos', 	-value => sub{ about( $cui ) } } ];
	my $menu = [
		{ -label => 'PlCoinCoin', 	-submenu=> $pl_menu },
		{ -label => 'Do it!',				-submenu=> $doit_menu },
		{ -label => 'Aide', 				-submenu=> $aide_menu }
	];
	my $menubar = $cui->add('menu', 'Menubar', -menu => $menu);

	# La fentre plcc
	my $plcc = $cui->add(
     'plcc', 'Window',
     -border => 0,
     -padtop => 1,
  );

	# Le pinnipde dans la fentre plcc
	my $pinni = $plcc->add(
     'pinni', 'Pinnipede',
     -title => "Pinnipde tltype ($PlccGlobal::nomTribune)",
		 -titlereverse=> 0,
     -border => 1,
     -vscrollbar => 1,
     -wrapping => 1,
     -padtop => 1,
     -padbottom => 5,
  );
	$pinni->addPosts( %tribune );
	$pinni->pos( length( $pinni->text ) );
	
	# Le palmipde dans la fentre plcc
	my $palmi = $plcc->add(
     'palmi', 'TextEditor',
     -title => 'Palmipde ditor',
		 -titlereverse=> 0,
     -border => 1,
     -vscrollbar => 1,
     -wrapping => 1,
		 -text=> "Coin ! Coin !",
	# C'est gruiiik, d'ailleurs, je sais pas pourquoi 5.
	# Enfin, si, c'est le pad du pinni, mais $pinni->height()
	# semble retourner la hauteur de toute la fentre. :-/
     -y => $pinni->height() -5 , 
  );
	$palmi->set_binding( sub{ post( $cui, $palmi ) }, Curses::KEY_ENTER );

	# Fentre de modification de l'ua
	create_edit_ua( $cui );

	# Raccourcis globaux
	$cui->set_binding( sub{ quitter( $cui ) }, "\cQ" );
	$cui->set_binding( sub{ shift()->root->focus('menu') }, "\cX" );
	$cui->set_binding( sub{ traiteTO() }, "\cR" );
	$cui->set_binding( sub{ shift()->layout() }, Curses::KEY_REFRESH );
	$palmi->focus();

	# Gestionnaires de signaux
	# Minuterie de rafrachissement du pinnipde
	$SIG{ ALRM } = sub { traiteTO };
	alarm( $PlccGlobal::minuterie );

	# Redimensionnement
	$SIG{ WINCH } = sub { print STDERR " ** SIGWINCH\n"; $cui->layout_contained_objects(); };

	$PlccLogger::logger->debug("Fin");
	
	return $cui;
}

1;
