##########################################################################
#                                                                        #
#                  This file is part of PerlCoinCoin                     #
#           Copyright 2003 - Loc Restoux  <lordoric@free.fr>            #
#                                                                        #
#                                                                        #
# PerlCoinCoin is free software; you can redistribute it  and/or  modify #
# it under the terms of the GNU General Public License as  published  by #
# the Free Software Foundation; either version 2 of the License, or  (at #
# your option) any later version.                                        #
#                                                                        #
# Foobar is distributed in the hope that it will be useful, but  WITHOUT #
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY  or #
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General  Public  License #
# for more details.                                                      #
#                                                                        #
# You should have received a copy of  the  GNU  General  Public  License #
# along with Foobar; if not, write  to  the  Free  Software  Foundation, #
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA            #
#                                                                        #
##########################################################################

package PlccGlobal;

use strict;
use Getopt::Long;  	# Pour la ligne de commande
use Plcc::PlccOptions;
use Plcc::PlccLogger;

# Incontournables
our $version="cvs";

our $plccDebug = undef;
our $tribuneCourante = undef;
our $configFile = undef;
our $help = undef;
our $minuterie = undef;

sub printSyntax()
{
	$PlccLogger::logger->debug("Debut");
	print << "EOF";

PlCoinCoin - $version - (c) Loc Restoux 2003 - Code sous licence GPL
Syntax: plcc.pl [-t|--tribune <tribune>] [-c|--config <fichier>] [-d|--debug] 
                [-h|--help] [-r|--refresh <temps>] 

 -h|--help: Affiche cette aide.
	
 -c|--config: Utilise le fichier de configuration spcifi. Ce fichier doit tre
               au format utilis par wmcoincoin. Par dfaut, le fichier 
               ~/.wmcoincoin/options est utilis.
	
 -t|--tribune: Spcifie la tribune  utiliser. Cette tribune doit tre prsente
               dans le fichier de configuration. Par dfaut, la tribune utilise
               est 'dlfp'. Attention : seul le nom de la tribune est utilisable,
               pas ses alias !

 -d|--debug: Affiche plein de btises sur le handle d'erreur standard. Pas trs 
             utilisable pour le moment. Et comme ncurses n'apprcie pas 
             vraiment, je conseille dans ce cas de rediriger la sortie :
             plcc.pl 2>> plcc.log

 -r|--refresh: Surcharge

Maisonpage sur http://lordoric.free.fr/plc/
Bugs, suggestions, et invitation  boire un coup : <lordoric.free.fr>
EOF

	$PlccLogger::logger->debug("Fin");
}

sub parseCmd
{
	$PlccLogger::logger->debug("Debut");

	GetOptions( "d|debug" => \$plccDebug,
							"t|tribune:s" => \$tribuneCourante,
							"h|help" => \$help,
							"c|config:s" => \$configFile,
							"r|refresh:i" => \$minuterie,
						)
		or ( printSyntax() 
				 and  $PlccLogger::logger->logdie("Arguments incorrects\n") );

	printSyntax() 
		and $PlccLogger::logger->logdie("Affichage de l'aide et fin") 
			if defined $help;

	$tribuneCourante = 'dlfp' unless defined $tribuneCourante;
	$configFile = '~/.wmcoincoin/options' unless defined $configFile;

	$PlccLogger::logger->debug("Fin");
	
	return 1;
}

sub init
{
	$PlccLogger::logger->debug("Debut");

	parseCmd( @_ );
	
	PlccOptions::readOptions( $configFile );
	PlccOptions::readOptionsAuth( $configFile.".auth" );
	PlccOptions::dump_option() if ( $PlccLogger::logger->is_debug() );

	$PlccLogger::logger->debug("hello ?");

	# Verification du parametre 'tribune'
	die "La tribune $tribuneCourante n'est pas configure dans $configFile\n"
		unless ( grep { $_ eq $tribuneCourante } @PlccOptions::listeTribune ) ;
	
	$PlccLogger::logger->debug("hello ?");

	# Lues dans le fichier de conf
	our $cookies = PlccOptions::getOption( 'cookie', $tribuneCourante );
	our $proxyHost = PlccOptions::getOption( 'http.proxy', $tribuneCourante );
	our $minuterie = PlccOptions::getOption( 'tribune.delay', $tribuneCourante ) unless defined $minuterie;
	$minuterie = 60 unless defined $minuterie;
	our $defautUA=PlccOptions::getOption( 'palmipede.useragent', $tribuneCourante );
	if ( defined $defautUA )
	{
		$defautUA =~ s/wm/pl/;
	}
	else
	{
		$defautUA = 'plCoinCoin/$v (tty; gloubiboulga; BloKK)';
	}
	$defautUA =~ s/\$v/$version/;
		
	my $proxyAuth = PlccOptions::getOption( 'http.proxy_auth', $tribuneCourante );
	our ( $proxyUser, $proxyPass ) = split /:/, $proxyAuth if defined $proxyAuth;

	# Bidouille
	our $backend_url=PlccOptions::getOption( 'backend.url', $tribuneCourante );
	$backend_url='http://linuxfr.org/board/remote.xml' unless ( defined $backend_url );

	# Une autre :(
	our $post_param=PlccOptions::getOption( 'post.template', $tribuneCourante );
	$post_param='message=%s' unless defined $post_param;

	# Encore
	our $post_url = PlccOptions::getOption( 'post.url', $tribuneCourante );
	$post_url = 'http://linuxfr.org/board/add.html' unless defined $post_url;
	
	# Divers
	our $nomTribune=$tribuneCourante;
	our $myUA=$defautUA;
	
	$PlccLogger::logger->debug("Fin");

	return 1;
}

1;
