##########################################################################
#                                                                        #
#                  This file is part of PerlCoinCoin                     #
#           Copyright 2003 - Loc Restoux  <lordoric@free.fr>            #
#                                                                        #
#                                                                        #
# PerlCoinCoin is free software; you can redistribute it  and/or  modify #
# it under the terms of the GNU General Public License as  published  by #
# the Free Software Foundation; either version 2 of the License, or  (at #
# your option) any later version.                                        #
#                                                                        #
# Foobar is distributed in the hope that it will be useful, but  WITHOUT #
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY  or #
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General  Public  License #
# for more details.                                                      #
#                                                                        #
# You should have received a copy of  the  GNU  General  Public  License #
# along with Foobar; if not, write  to  the  Free  Software  Foundation, #
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA            #
#                                                                        #
##########################################################################

package PlccOptions;

use strict;
use Plcc::PlccLogger;

# Variables globales contenant les options
# ----------------------------------------
our ( @listeTribune, %configTribune, %configGenerale );

# Retourne la valeur d'une option
# -------------------------------
# Option: nom de l'option
# Name: nom de la tribune (si non spcifi, on cherche dans les options gnrales)
# Si l'option n'est pas trouve dans la tribune, elle est recherch dans les
# options gnrales.
sub getOption
{
	$PlccLogger::logger->debug("Debut");

	my ( $option, $name ) = @_;
	my $value;

	if ( defined $name )
	{
		print STDERR "$name.$option\n" if ( $PlccGlobal::plccDebug );
		$value = $configTribune{ "$name.$option" };
	}
	
	if ( not defined $name or not defined $value )
	{
		print STDERR "$option\n" if ( $PlccGlobal::plccDebug );
		$value = $configGenerale{ $option };
	}

	print STDERR "$value\n" if ( defined $value and $PlccGlobal::plccDebug );

	$PlccLogger::logger->debug("Fin");

	return $value;
}



# Charge les options du fichier dont le nom est pass en paramtre
# ----------------------------------------------------------------
# + Si aucun paramtre n'est pass, tente d'ouvrir le fichier par dfaut
# + Retourne trois variables :
# 	+ un tableau des noms des tribunes
# 	+ un hachage des options de chacune des tribunes
# 	+ un hachage des options de configuration gnrale (non attaches  une tribune)

sub readOptions
{
	$PlccLogger::logger->debug("Debut");

	my ($optFileName) = @_;
	my $tribuneCourante;

	# Lecture du fichier
	open FILE, glob( glob $optFileName ) 
		or die "Erreur de lecture de $optFileName\n";
	
	# Traitement des options
	while ( my $line = <FILE> )
	{
		# On rassemble les lignes multiples (finissent pas \)
		while ( (my $debut ) = ( $line =~ /(.*)\\$/ ) )
		{
			$line = $debut.<FILE>;
		}

		# On saute les lignes dbutant par #
		next if $line =~ /^\s*#/;	

		$PlccLogger::logger->debug("Traitement de la ligne : $line");

		# Une ligne de dfinition de tribune
		if ( my ( $tribune, $bidon, $alias ) = ( $line =~ /^board_site:\s*"([^"]*)"(\s*,\s*)?(.*)?$/ ) )
		{
			$PlccLogger::logger->debug("Ajout de la tribune $tribune ($alias)");
			$tribuneCourante = $tribune;
			push( @listeTribune, $tribune );
			$configTribune{ "$tribuneCourante.alias" } = $alias;
			next;
		}

		# Une ligne de feed rss (on poubellise)
		if ( my ( $tribune, $bidon, $alias ) = ( $line =~ /^rss_site:\s*"([^"]*)"(\s*,\s*)?(.*)?$/ ) )
		{
			$PlccLogger::logger->debug("Feed RSS $tribune");
			$tribuneCourante = "trash";
			next;
		}

		

		# Une ligne de configuration de tribune 
		if ( my ( $options, $value ) = ( $line =~ /^\.(.*): (.*)$/ ) )
		{
			$PlccLogger::logger->debug("Tribune $tribuneCourante, option $options : $value");
			$configTribune{ "$tribuneCourante.$options" } = $value;
			next;
		}
			
		# Sinon, c'est de la configuration gnrale
		my ( $option, $value ) = ( $line =~ /^(.*): (.*)$/ );
		$PlccLogger::logger->debug("Gnral, option $option : $value");
		$configGenerale{ $option } = $value;
		next;
	}	


	close FILE;
	
	$PlccLogger::logger->debug("Fin");

	return ( \@listeTribune, \%configGenerale, \%configTribune );
}

# Charge les options d'authentification (cookies) du fichier dont le nom est pass en paramtre
# ---------------------------------------------------------------------------------------------
# + Paramtres : 
#   + Nom du fichier de conf
sub readOptionsAuth
{
	$PlccLogger::logger->debug("Debut");

	my ($optFileName) = @_;

	# Lecture du fichier
	open FILE, glob( glob $optFileName ) 
		or die "Erreur de lecture de $optFileName\n";
	
	# Traitement des options
	while ( my $line = <FILE> )
	{
		# On saute les lignes dbutant par #
		next if $line =~ /^\s*#/;	

		my ($tribune, $option, $value) = ( $line =~ /^"(.*)?"\s*(.*)?:\s*"(.*)?"$/ );
		$configTribune{ "$tribune.$option" } = $value;
	}

	close FILE;
	
	return ( \%configTribune );
}



# Dump des options dans le fichier de log
# ---------------------------------------
sub dump_option
{
	$PlccLogger::logger->debug("Debut");

	my @list = @listeTribune;
	my %gen = %configGenerale;
	my %trib = %configTribune;

	$PlccLogger::logger->debug(" == Configuration gnrale ==");
	map { $PlccLogger::logger->debug("$_ = $gen{ $_} ") } keys( %gen );
	$PlccLogger::logger->debug(" == Liste des tribunes ==");
	map { $PlccLogger::logger->debug("$_\n") } @list;
	$PlccLogger::logger->debug(" == Configuration des tribunes ==");
	map { $PlccLogger::logger->debug("$_ = $trib{ $_} ") } sort keys( %trib );

	$PlccLogger::logger->debug("Fin");
}

1;
