#!/usr/bin/perl 

##########################################################################
#                                                                        #
#                  This file is part of PerlCoinCoin                     #
#           Copyright 2003 - Loc Restoux  <lordoric@free.fr>            #
#                                                                        #
#                                                                        #
# PerlCoinCoin is free software; you can redistribute it  and/or  modify #
# it under the terms of the GNU General Public License as  published  by #
# the Free Software Foundation; either version 2 of the License, or  (at #
# your option) any later version.                                        #
#                                                                        #
# Foobar is distributed in the hope that it will be useful, but  WITHOUT #
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY  or #
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General  Public  License #
# for more details.                                                      #
#                                                                        #
# You should have received a copy of  the  GNU  General  Public  License #
# along with Foobar; if not, write  to  the  Free  Software  Foundation, #
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA            #
#                                                                        #
##########################################################################

use strict;
use Plcc::PlccNet;
use Plcc::PlccGUI;
use Plcc::PlccGlobal;
use Plcc::PlccOptions;
use Plcc::PlccLogger qw($logger);

open STDERR,">>plcc.stderr";

$PlccLogger::logger->fatal("Dmarrage...");

# Initialisation
PlccGlobal::init( @ARGV ) or $PlccLogger::logger->error_die("Erreur d'initialisation");

# Rcupration du backend
%PlccGlobal::tabPost = PlccNet::refreshBackend( );

# Affichage de l'interface
$PlccGUI::cui = PlccGUI::launchGUI( %PlccGlobal::tabPost );

# Affichage des raccourcis (C'EST CTRL+X POUR LE MENU !)
PlccGUI::shortcuts( $PlccGUI::cui );

# Boucle de l'interface
$PlccGUI::cui->MainLoop;
