#include <db.h> 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "store.h"

//permanent database
DB *database=NULL;
//temporary learning database
DB *tempDB = NULL;
//stored returned values
unsigned char ret[4];
unsigned int valeur[2];

/*
* Open the permanent database.
* @param dbname name of the permanent database
*/
void store_opendb(char *dbname)
{
  int ret;
  u_int32_t flags;
  
  if(database==NULL){

    ret = db_create(&database, NULL, 0);
    if (ret != 0){
      fprintf(stderr, "Error while creating database\n");
      exit(0);
    }
    
    database->set_cachesize(database,0,(unsigned int)270384*270384,1);
    flags = DB_CREATE;
    
    ret = database->open(database,       
			 NULL,       
			 dbname, 
			 0,       
			 DB_BTREE,   
			 flags,     
			 0);  
    if(ret != 0){
      fprintf(stderr, "Error while opening database");
    }
  }
}

/*
* Open the temporary database and then call store_opendb to open the permanent one.
* @param dbname name of the permanent database
*/
void store_opendbs(char *dbname)
{
    int ret;
    u_int32_t flags;

    flags = DB_CREATE|DB_TRUNCATE;
    ret = db_create(&tempDB, NULL, 0);
    if (ret != 0){
    fprintf(stderr, "Error while creating database\n");
    exit(0);
    }

    tempDB->set_cachesize(tempDB,0,(unsigned int)270384*270384,1);
    ret = tempDB->open(tempDB,
                       NULL,
                       NULL,
                       0,
                       DB_BTREE,
                       flags,
                       0);

    if(ret != 0){
      fprintf(stderr, "Error while opening basetemp");
    }

    store_opendb(dbname);
}

/*
* Display all the tokens stored in the permanent database.
*/
void store_displayTokens()
{     
  int ret;
  unsigned int *porn;
  DBT key, data;
  DBC *cursorp;
  
  database->cursor(database, NULL, &cursorp, 0);  
  
  memset(&key, 0, sizeof(DBT));
  memset(&data, 0, sizeof(DBT));    
  
  while ((ret = cursorp->c_get(cursorp, &key, &data, DB_NEXT)) == 0) {
    porn = to_int(data.data);
    printf("%-45s : porn : %5u non porn %5u\n", (char*)key.data, porn[0], porn[1]);
  }
  
  if (cursorp != NULL) 
    cursorp->c_close(cursorp); 
}

/*
* Get the number of "bad" and "good" occurences of a token in the permanent database.
* @param token the token to get the score from
* @return data.data the number of occurences
*/
unsigned int* store_getScore(char *token)
{     
  int ret;
  DBT key, data;
  
  memset(&key, 0, sizeof(DBT));
  memset(&data, 0, sizeof(DBT));    
 
  key.data = token;
  key.size = strlen(token)+1;

  ret = database->get(database, NULL, &key, &data, 0);

  if(ret == DB_NOTFOUND){
     valeur[0] = 0;
     valeur[1] = 0;
     return (valeur);
  }else
    return (to_int(data.data));
}

/*
* Store a token in thye temporary learning database (or learning tokens are counted just once per page).
* @param token the token to store
* @param type the type of token (tag, word, biword or domain)
*/
void store_storeTempToken(char *token, int type)
{
 int ret;
 DBT key, data;
 unsigned char *val=NULL;
 char *debut = NULL;
 char *chaine = NULL;

 switch(type){
 case TAGS :
   debut = malloc(sizeof(char)*(strlen("tag:")+1));
   strcpy(debut, "tag:");
   break;
 case WORDS :
   debut = malloc(sizeof(char)*(strlen("word:")+1));
   strcpy(debut, "word:");
   break;
 case BIWORDS :
   debut = malloc(sizeof(char)*(strlen("biword:")+1));
   strcpy(debut, "biword:");
   break;
 case DOMAINS :
   debut = malloc(sizeof(char)*(strlen("domain:")+1));
   strcpy(debut, "domain:");
   break;
 default :
   debut =  malloc(sizeof(char)*(strlen("")+1));
   strcpy(debut, "");
   break;
 }

 memset(&key, 0, sizeof(DBT));
 memset(&data, 0, sizeof(DBT));

 chaine = malloc(sizeof(char)*(strlen(token)+strlen(debut)+1));
 strcpy(chaine, debut);
 strcat(chaine, token);

 key.data = chaine;
 key.size = strlen(chaine)+1;

 val = to_hex(1, 0);

 data.data = val;
 data.size = 4;

 ret = tempDB->put(tempDB, NULL, &key, &data, DB_NOOVERWRITE);

 if (debut != NULL) {free(debut); debut=NULL;}
 else printf("var debut NULL in store_storeToken");
 if(chaine != NULL) {free(chaine); chaine=NULL;}
 else printf("var chaine NULL in store_storeToken\n");
}

/*
* Store all the token from the temporary learning database to the permanent one.
* @param isporn (1 = "is porn", 0 = "is not porn")
*/
void store_storeAll(int isporn)
{
  int retb;
  DBT key, data;
  DBC *cursorp;

  tempDB->cursor(tempDB, NULL, &cursorp, 0);
  memset(&key, 0, sizeof(DBT));
  memset(&data, 0, sizeof(DBT));

  while ((retb = cursorp->c_get(cursorp, &key, &data, DB_NEXT)) == 0) {
	store_storeToken(key.data, isporn);
	cursorp->c_del(cursorp, 0);
  }

  if (cursorp != NULL)
    cursorp->c_close(cursorp);

}

/*
* Store a token in the permanent database.
* @param token the token to store
* @param isporn (1 = "is porn", 0 = "is not porn") 
*/
void store_storeToken(char *token, int isporn)
{
 int ret; 
 DBT key, data;
 unsigned int *tmp; 
 unsigned char *val=NULL;     

 memset(&key, 0, sizeof(DBT));
 memset(&data, 0, sizeof(DBT));    
 
 key.data = token;
 key.size = strlen(token)+1;
 
 val = to_hex(isporn, 1 - isporn);

 data.data = val;
 data.size = 4; 
  
 ret = database->put(database, NULL, &key, &data, DB_NOOVERWRITE);
 if (ret == DB_KEYEXIST) {
   database->get(database, NULL, &key, &data, 0);
   tmp = to_int(data.data);
   val = to_hex(tmp[0]+isporn, tmp[1]+1-isporn);
   data.data = val;
   data.size = 4;
   database->put(database, NULL, &key, &data, 0);
 }
}

/*
* Close the permanent and temporary databases
*/
void store_closedb()
{  
  if (database != NULL)
    database->close(database, 0);
  if (tempDB != NULL)
    tempDB->close(tempDB, 0); 
}

/*
* Convert a pair of int values to an hex one (4 bytes) to store in the database
* @param nbp number of porn occurences of a token
* @param nbn number of non porn occurences of the same token
* @return ret the converted value
*/
unsigned char* to_hex(unsigned int nbp, unsigned int nbn)
{
  ret[0] = (nbp/256);
  ret[1] = (nbp%256);

  ret[2] = (nbn/256);
  ret[3] = (nbn%256);

  return ret;
}

/*
* Convert a hex value (4 bytes) to a pair of int values
* @param conv hex value to convert
* @return valeur returned array
*/
unsigned int* to_int(unsigned char *conv)
{
  valeur[0] = conv[0]*256 + conv[1];
  valeur[1] = conv[2]*256 + conv[3];

  return(valeur);
}
