#!/usr/bin/ruby

require 'libperceptron.rb'
require 'token'
require 'hashdb'

class Network
  
  def initialize(basename,netparams)
    @netparams = netparams

    @value = Hash.new(0)
    @proba = Hash.new(0)
    @fw    = Hash.new(0)
    @ch    = Hash.new(0)
    @db = Hashdb.new(basename, 'r+')

    @BAD, @GOOD  = @db.getScore("~~nombre-pages~~")

    @x = 0.5
    @s = 1
    @dev = 0.4

    @min = 30
  end


  def getVector(file)
    content_file = file
    listToken = Token.new(content_file)
    hash = listToken.get_all
    
    if hash.length < @min
      return "fichier non pris en compte car trop petit"
    end

    vecteur = []
    for i in 0..19
      vecteur[i] = 0
    end

    count = 0
    hash.keys.each{|t|
      bad,good = @db.getScore(t)
      v = hash[t]

      if bad+good > 1 
        proba = getGrahamProbability(bad, good)
        fw = (@s*@x + (bad+good)*proba)/(@s+bad+good)
        count +=1
        vecteur[min((fw*20).floor,19)] += v 

        @value[t] = "#{v}"
        @proba[t] = "#{proba}" 
        @fw[t]    = fw 
      end
    }
    return (vecteur.map {|x| 1.0*x/count}.join ' ')
  end


  def learnFromVectorFile(filePorn, fileNoPorn)
    vec = []
    while line = filePorn.gets
      vec << [line.split(/ +/).map{|str| str.to_f},[1]]
    end
    
    while line = fileNoPorn.gets
      vec << [line.split(/ +/).map{|str| str.to_f},[0]]
    end
    
    n = Neural.new(20,10,1)
    vec.sort {|a,b| rand(3)-1}.each {|tab|
      next if tab[0].length != 20
      puts(n.learn(tab[0],tab[1],0.01))
    }
    
    n.save(@netparams)
  end


  def workNetwork(file)
    vec = []
    vecteur = getVector(file)
    vec << vecteur.split(/ +/).map{|str| str.to_f}
    n = Neural.new(20,10,1)
    n.load(@netparams)
    #puts vec[0]
    return n.work(vec[0])
  end

  ## Retourne la probabilité de Graham d'un token ##
  #équivaut a la technique de scaleFactor de Cedric
  def getGrahamProbability(bad, good)
    return (1.0*bad/@BAD)/((1.0*bad/@BAD)+(1.0*good/@GOOD))
  end

  def getInfo()
    info = []
    tri  =  @fw.sort{|a,b| a[1]<=>b[1]}
    tri.each{|t,v|
      info << "#{t.ljust(35)} #{@value[t].ljust(5)} #{@proba[t].ljust(20)} #{@fw[t].to_s.ljust(20)} #{@ch[t]}"
    }
    return info
  end

  def min(a,b)
    if a<b
      return a
    else
      return b
    end
  end


end

