#!/usr/bin/env python
#-*- coding: latin-1 -*-

# gdal_shade.py 081202
# Copyright 2008 Gregorio Díaz-Marta Mateos
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with This program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""Generate hillshade for a DEM.
 
Usage: python gdal_shade.py src dst

"""

import sys
import gdalhelper

def usage():
    """Print usage advices."""
    print __doc__

if __name__ == '__main__':
    args = sys.argv

    try:
        src, dst = sys.argv[1], sys.argv[2]
    except e:
        print e
        usage()
        sys.exit(1)

    gdalhelper.gdal_shade(src, dst)
