#!/usr/bin/env python
#-*- coding: latin-1 -*-

# helper.py 081202
# Copyright 2008 Gregorio Díaz-Marta Mateos
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""Helper functions which not depend on gdal."""

import os

def gen_wld(gt, name):
    """Generate an ESRI World File.

    gt: geotransform
    name: name of the original dataset

    """

    name, ext = os.path.splitext(name)
    name = os.path.extsep.join((name, 'wld'))
    wldfile = open(name, 'w')
    wldfile.write('%r\n%r\n%r\n%r\n%r\n%r\n'
                  % (gt[1], gt[4], gt[2], gt[5], gt[0], gt[3]))
    wldfile.close()
    
def add_coords(name, x, y):
    """Add coordinate values to a file name."""
    name, ext = os.path.splitext(name)
    name = '%s_%d_%d%s' % (name, x, y, ext)
    return name
