#!/usr/bin/env python
# -*- coding: latin-1 -*-

# CurveEditor.py
# Copyright 2008 Gregorio Díaz-Marta Mateos
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


import pygtk
pygtk.require('2.0')
import gtk
import windpower as wp
from Observable import ObservableEvent
from PowerCalc import PowerCalc
from CurveInfoEditor import CurveInfoEditor
from CurveGrid import CurveGrid


class CurveEditor(gtk.HBox):
    """Widget for power curve editing."""
    def __init__(self, curve):
        gtk.HBox.__init__(self)
        self.curve_changed = ObservableEvent()
        self._curve = curve        

        sw = gtk.ScrolledWindow()
        sw.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
        self.pack_start(sw)

        self.grid = CurveGrid(curve)
        sw.add(self.grid)

        vbox = gtk.VBox()
        self.pack_start(vbox)

        self.info = CurveInfoEditor(curve)
        vbox.pack_start(self.info)

        expander = gtk.Expander('AEP calculator')
        vbox.pack_start(expander)
        self.calc = PowerCalc(curve)
        expander.add(self.calc)

        self.info.changed.register(self.info_changed_cb)

        # Ugly but necessary for setting callbacks.
        # Some refactoring should be done around.
        self.setCurve(curve)

    def info_changed_cb(self, event):
        self.update()

    def curve(self):
        return self._curve

    def curve_old(self):
        """Return the curve from widget values."""
        curve = wp.PowerCurve()
        curvedict = self.grid.get_dict()
        curve.update(curvedict)

        if self.info.get_has_explicit_rated_power():
            ratedpower = self.info.get_rated_power()
            curve.setRatedPower(ratedpower)

        if self.info.get_has_explicit_cut_in():
            cutin = self.info.get_cut_in()
            curve.setCutIn(cutin)

        if self.info.get_has_explicit_cut_out():
            cutin = self.info.get_cut_out()
            curve.setCutIn(cutin)

        return curve

    def setCurve(self, curve):
        self._curve = curve
        self.info.set_curve(curve)
        self.grid.setCurve(curve)
        self.calc.setCurve(curve)

        m = self.grid.get_model()
        m.connect('row_changed', self.grid_row_changed)
        m.connect('row_inserted', self.grid_row_inserted)
        m.connect('row_deleted', self.grid_row_deleted)

    def grid_row_changed(self, model, path, iter):
        self.update()

    def grid_row_inserted(self, model, path, iter):
        self.update()

    def grid_row_deleted(self, model, path):
        self.update()

    def update(self):
        newdict = self.grid.get_dict()
        curve = self.curve()
        curve.clear()
        curve.update(newdict)
        self.calc.update()
        self.info.update()
        self.curve_changed.happen()

    def add_row(self):
        self.grid.add_row()

    def remove_row(self):
        self.grid.remove_row()
