#!/usr/bin/env python
# -*- coding: latin-1 -*-

# CurveEditor.py
# Copyright 2008 Gregorio Díaz-Marta Mateos
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


import pygtk
pygtk.require('2.0')
import gtk


class DictStore(gtk.ListStore):
    """A ListStore created from a dictionary."""

    def __init__(self, dict):
        gtk.ListStore.__init__(self, float, float)
        speeds = sorted(dict.keys())
        powers = [dict[s] for s in speeds]
        for s in speeds:
            self.append([s, dict[s]])

    def get_dict(self):
        """Return iself as a dictionary.

        Items in the output are (r[0], r[1]) for each row r in the model.

        """

        output = {}
        for row in self:
            speed, power = map(float, row)
            output[speed] = power
        return output


class CurveGrid(gtk.TreeView):
    """Curve editor GTK widget.

    As for now this widget just provides a speed - power table (TreeView).
    It's actually a dictionary editor.

    """

    def __init__(self, curve):
        gtk.TreeView.__init__(self)
        self.setCurve(curve)
        self.set_grid_lines(gtk.TREE_VIEW_GRID_LINES_BOTH)

        speedCell = gtk.CellRendererText()
        powerCell = gtk.CellRendererText()

        speedCell.set_property('editable', True)
        powerCell.set_property('editable', True)

        speedCell.connect('edited', self.cell_edited, 0)
        powerCell.connect('edited', self.cell_edited, 1)

        speedColumn = gtk.TreeViewColumn('Speed')
        powerColumn = gtk.TreeViewColumn('Power')

        speedColumn.set_resizable(True)
        powerColumn.set_resizable(True)
 
        speedColumn.pack_start(speedCell)
        powerColumn.pack_start(powerCell)

        speedColumn.set_cell_data_func(speedCell, self.cell_data_func, 0)
        powerColumn.set_cell_data_func(powerCell, self.cell_data_func, 1)

        speedColumn.set_sort_column_id(0)

        self.append_column(speedColumn)
        self.append_column(powerColumn)

    def cell_data_func(self, column, cell, model, iter, modelcol):
        value = model[iter][modelcol]
        cell.set_property('text', str(value))

    def cell_edited(self, cell, path, new_text, col):
        new_number = float(new_text)
        model = self.get_model()
        if col == 0:
            d = model.get_dict()
            if d.has_key(new_number):
                raise Exception('Can\'t define two power values for one speed')
        model[path][col] = new_number
        
    def setCurve(self, curve):
        model = DictStore(curve)
        self.set_model(model)

    def get_dict(self):
        return self.get_model().get_dict()

    def add_row(self):
        """Add an empty row."""
        m = self.get_model()
        m.append()

    def remove_row(self):
        s = self.get_selection()
        m, i = s.get_selected()
        m.remove(i)
