#!/usr/bin/env python
# -*- coding: latin-1 -*-

# PowerCalc.py
# Copyright 2008 Gregorio Díaz-Marta Mateos
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


import pygtk
pygtk.require('2.0')
import gtk
import windpower as wp


class PowerCalc(gtk.Table):
    """A power calculator widget."""
    def __init__(self, curve):
        gtk.Table.__init__(self, 5, 2)

        self.weibull_A = gtk.Entry()
        self.weibull_A.set_text('7.0')
        self.weibull_k = gtk.Entry()
        self.weibull_k.set_text('2.0')
        self.avgPower = gtk.Entry()
        self.avgPower.set_editable(False)
        self.aep = gtk.Entry()
        self.aep.set_editable(False)
        self.aeh = gtk.Entry()
        self.aeh.set_editable(False)

        label = gtk.Label('A:')
        self.attach(label, 0, 1, 0, 1)
        self.attach(self.weibull_A, 1, 2, 0, 1)
        label = gtk.Label('k:')
        self.attach(label, 0, 1, 1, 2)
        self.attach(self.weibull_k, 1, 2, 1, 2)
        label = gtk.Label('Power:')
        self.attach(label, 0, 1, 2, 3)
        self.attach(self.avgPower, 1, 2, 2, 3)
        label = gtk.Label('AEP (kWh):')
        self.attach(label, 0, 1, 3, 4)
        self.attach(self.aep, 1, 2, 3, 4)
        label = gtk.Label('AEP (hours):')
        self.attach(label, 0, 1, 4, 5)
        self.attach(self.aeh, 1, 2, 4, 5)

        self.weibull_A.connect('focus-out-event', self.update)
        self.weibull_k.connect('focus-out-event', self.update)

        self.setCurve(curve)

    def curve(self):
        return self._curve

    def setCurve(self, curve):
        self._curve = curve
        self.update()

    def update(self, widget=None, params=None):
        curve = self.curve()
        try:
            A = float(self.weibull_A.get_text())
            k = float(self.weibull_k.get_text())
            power = curve.avgPower(k, A)
        except ValueError:
            power = 0.0
        self.weibull_A.set_text(str(A))
        self.weibull_k.set_text(str(k))
        self.avgPower.set_text(str(power))
        aep = power * 365 * 24
        self.aep.set_text(str(aep))
        if power != 0.0:
            aeh = aep / curve.ratedPower()
        else:
            aeh = 0.0
        self.aeh.set_text(str(aeh))
