/*
 * proccpuinfo.h - public interface for libproccpuinfo
 *
 * Copyright (C) 2006  Thomas Cort <linuxgeek@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __PROCCPUINFO_H
#define __PROCCPUINFO_H

typedef struct proccpuinfo {
	char *architecture;
	char *hardware_platform;
	double frequency;		/* in MHz */
	double bogomips;
	unsigned int cache;		/* in KB  */
	unsigned int cpus;		/* number of processors */
} proccpuinfo;

proccpuinfo *proccpuinfo_read();
void proccpuinfo_free(proccpuinfo *);

int   proccpuinfo_get_arch();
char *proccpuinfo_get_filename();

void proccpuinfo_set_arch(int);
void proccpuinfo_set_filename(char*);

int proccpuinfo_decode_arch(char*);

#endif
