%{
#include <ctype.h>
#include <stdio.h>
#include <string.h>

int lineno;
char *s;
extern char *__proccpuinfo_key[];
char *proccpuinfo_get_filename();
void __proccpuinfo_remove_whitespace(char *buf);
static int yywrap(void);
%}

%%

[^\n]*[\n]	{ 
			lineno++;

			s = (char *) malloc(strlen(yytext)*sizeof(char*)+1);
			strcpy(s,yytext);
			s[strlen(s)-1] = '\0';
			return 1;
		}

.		{
			return 0;
		}
%%

int yywrap() {
	return 1;
}

char *__proccpuinfo_get_value(int target_key) {
	yyin = fopen(proccpuinfo_get_filename(),"r");

	if (!yyin) {
		return NULL;
	}

	while (yylex()) {
		char *key = s, *target_value, *delim, *value;

		delim = strchr(s,':');

		if (delim) {
			s[delim-s] = '\0';
			target_value = delim + 1;
		} else
			target_value = NULL;

		__proccpuinfo_remove_whitespace(key);
		if (key && target_value && strlen(key) == strlen(__proccpuinfo_key[target_key]) && !strcmp(key, __proccpuinfo_key[target_key])) {
				__proccpuinfo_remove_whitespace(target_value);

				if (!(value = (char *) malloc(strlen(target_value)+1))) {
					free(s);
					fclose(yyin);
					yylex_destroy();
					return NULL;
				}

				strncpy(value,target_value,strlen(target_value)+1);
				free(s);
				fclose(yyin);
				yylex_destroy();

				return value;

		}
		free(s);
	}

	fclose(yyin);
	yylex_destroy();
	return NULL;
}

int __proccpuinfo_get_count(int target_key) {
	unsigned int count = 0;
	yyin = fopen(proccpuinfo_get_filename(),"r");

	if (!yyin) {
		return 0;
	}

	while (yylex()) {
		char *key = s, *target_value, *delim;

		delim = strchr(s,':');

		if (delim) 
			s[delim-s] = '\0';

		__proccpuinfo_remove_whitespace(key);
		if (!strcmp(key, __proccpuinfo_key[target_key])) {
			count++;
		}
		free(s);
	}

	fclose(yyin);
	yylex_destroy();
	return count;
}
