/**************************************************************************************

	PROTUX - THE FREE PROFESSIONAL AUDIO TOOLS FOR LINUX
	AUTHOR : See AUTHORS file for details

	This software is distributed under the terms of the GNU General Public License
	as specified in the COPYING file.

***************************************************************************************/
#ifndef AUDIOCLIP_HH
#define AUDIOCLIP_HH

#include <mustux.h>

class Audio;
class Song;
class Track;

class AudioClip : public MustuxDrawableRegion, public MustuxObject
	{
	public:

		AudioClip(Track* pParentTrack, Audio *anAudioSource, long long aSourceFirstBlock, long long aLenght, long long aTrackInsertPos);
		~AudioClip();

		void update();
		int draw();
		int draw_clip_rect();
		int play();
		int split();
		void clear();
		void set_muted(bool b);

		long long get_lenght();

		Audio* get_audio_source();
		AudioClip* prev;
		AudioClip* next;
		Track* parentTrack;
		Song* parentSong;
		Audio* audioSource;
		void set_blur(bool stat);
		void set_gain(float g);
		float get_fade_factor_for(long long pos);

		QString clipName;
		long long sourceFirstBlock;
		long long sourceLastBlock;
		long long trackFirstBlock;
		long long trackLastBlock;

		int blockSize;
		int channels;
		int rate;
		int bitDepth;
		long maxSample;

		float gain;

		void set_track_first_block(long long newTrackFirstBlock);
		void set_left_edge(long long block);
		void set_right_edge(long long block);
		void set_last_source_block(long long block);
		void set_first_source_block(long long block);

		void set_fade_in(long long b);
		void set_fade_out(long long b);

		int get_baseX();
		int get_baseY();
		int get_width();
		int get_height();

		bool is_muted() { return isMuted; };
		bool is_take() { return isTake; };
		bool isMuted;
		bool isTake;

		int progress;
		long long fadeOutBlocks;
		long long fadeInBlocks;


	private:
		QString clipInfo;
		QString sRate;
		QString sBitDepth;
		QString sourceType;
		QString sclipGain;
	};

#include "Audio.hh"
#include "Track.hh"
#include "Song.hh"

#endif
