#ifndef BUSSELECTOR_HH
#define BUSSELECTOR_HH

#include <mustux.h>

#include <qtimer.h>

class Mixer;

class BusSelector : public MustuxDrawableRegion
        {
        Q_OBJECT


        public:

                static const int IN = 0;
                static const int OUT = 1;
                BusSelector(MustuxDrawable* pDrawArea, Mixer* pMixer);
                ~BusSelector();

                void show_list();
                void start(int pDirection);
                void stop();
                int get_selected_bus();
                QString get_selected_bus_name();
                
        private:
                QTimer* updateTimer;
                int rootx;
                int rooty;
                int windowWidth;
                int windowHeight;
                int lastPointedLine;
                int colorChangeVal;
                int colorChangeFactor;
                int direction;
                int numBuses;
                Mixer* assocMixer;
                
        public slots:
                void update_selection();

        };

#include "Mixer.hh"

#endif
